/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.rei;

import aztech.modern_industrialization.compat.viewer.impl.ViewerUtil;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariantAttributes;
import aztech.modern_industrialization.util.FluidHelper;
import com.google.common.primitives.Ints;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ReiSlotUtil {
    private ReiSlotUtil() {
    }

    public static EntryStack<?> createFluidEntryStack(FluidVariant fluid, long amount, float probability, boolean input) {
        @Nullable Component probabilityText = ViewerUtil.getProbabilityTooltip(probability, input);
        return EntryStacks.of((FluidStack)FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)fluid.toStack(Ints.saturatedCast((long)amount)))).setting(EntryStack.Settings.TOOLTIP_PROCESSOR, (stack, oldTooltip) -> {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(FluidVariantAttributes.getName(fluid));
            tooltip.add(FluidHelper.getFluidAmount(amount));
            if (probabilityText != null) {
                tooltip.add(probabilityText);
            }
            return Tooltip.create(tooltip);
        });
    }

    public static EntryStack<?> createFluidNoAmount(FluidVariant fluid) {
        return EntryStacks.of((FluidStack)FluidStackHooksForge.fromForge((net.neoforged.neoforge.fluids.FluidStack)fluid.toStack(1000))).setting(EntryStack.Settings.TOOLTIP_PROCESSOR, (stack, oldTooltip) -> {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add(FluidVariantAttributes.getName(fluid));
            return Tooltip.create(tooltip);
        });
    }

    public static Function<EntryStack<?>, List<Component>> getProbabilitySetting(float probability, boolean input) {
        @Nullable Component tooltip = ViewerUtil.getProbabilityTooltip(probability, input);
        return es -> tooltip == null ? List.of() : List.of(tooltip);
    }
}

