/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.dynreg;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.resources.ResourceKey;

public final class DynamicRegistryDatagen {
    private static final List<Runnable> actions = new ArrayList<Runnable>();
    private static final Map<ResourceKey<? extends Registry<?>>, List<RegistrySetBuilder.RegistryBootstrap<?>>> entries = new LinkedHashMap();

    public static void addAction(Runnable action) {
        actions.add(action);
    }

    public static <T> void add(ResourceKey<? extends Registry<T>> registry, RegistrySetBuilder.RegistryBootstrap<T> bootstrap) {
        entries.computeIfAbsent(registry, k -> new ArrayList()).add(bootstrap);
    }

    public static RegistrySetBuilder getBuilder() {
        RegistrySetBuilder builder = new RegistrySetBuilder();
        actions.forEach(Runnable::run);
        for (Map.Entry<ResourceKey<Registry<?>>, List<RegistrySetBuilder.RegistryBootstrap<?>>> entry : entries.entrySet()) {
            builder.add(entry.getKey(), ctx -> {
                for (RegistrySetBuilder.RegistryBootstrap bootstrap : (List)entry.getValue()) {
                    bootstrap.run(ctx);
                }
            });
        }
        return builder;
    }

    private DynamicRegistryDatagen() {
    }
}

