/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.datamaps.FluidFuel;
import aztech.modern_industrialization.definition.FluidDefinition;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.util.ItemStackHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;

public class FluidItemConsumerComponent
implements IComponent.ServerOnly {
    protected long euBuffer = 0L;
    public final long maxEuProduction;
    public final EUProductionMap<Item> itemEUProductionMap;
    public final EUProductionMap<Fluid> fluidEUProductionMap;

    public FluidItemConsumerComponent(long maxEuProduction, EUProductionMap<Item> itemEUProductionMap, EUProductionMap<Fluid> fluidEUProductionMap) {
        this.itemEUProductionMap = itemEUProductionMap;
        this.fluidEUProductionMap = fluidEUProductionMap;
        this.maxEuProduction = maxEuProduction;
    }

    public boolean doAllowMoreThanOne() {
        return this.itemEUProductionMap.getNumberOfFuel() == NumberOfFuel.MANY || this.fluidEUProductionMap.getNumberOfFuel() == NumberOfFuel.MANY;
    }

    public static FluidItemConsumerComponent ofSingleFluid(long maxEuProduction, FluidDefinition acceptedFluid, long fluidEUperMb) {
        return FluidItemConsumerComponent.ofFluid(maxEuProduction, new EuProductionMapBuilder(BuiltInRegistries.FLUID).add(acceptedFluid.getId(), fluidEUperMb).build());
    }

    public static FluidItemConsumerComponent ofFluidFuels(long maxEuProduction) {
        return new FluidItemConsumerComponent(maxEuProduction, EUProductionMap.empty(), FluidItemConsumerComponent.fluidFuels());
    }

    public static FluidItemConsumerComponent ofFluid(long maxEuProduction, EUProductionMap<Fluid> fluidEUProductionMap) {
        return new FluidItemConsumerComponent(maxEuProduction, EUProductionMap.empty(), fluidEUProductionMap);
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putLong("euBuffer", this.euBuffer);
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.euBuffer = tag.getLong("euBuffer");
    }

    public long getEuProduction(List<ConfigurableFluidStack> fluidInputs, List<ConfigurableItemStack> itemInputs, long maxEnergyInsertable) {
        long maxEuProduced = Math.min(maxEnergyInsertable, this.maxEuProduction);
        if (maxEuProduced == 0L) {
            return 0L;
        }
        if (this.euBuffer >= maxEuProduced) {
            this.euBuffer -= maxEuProduced;
            return maxEuProduced;
        }
        long euProduced = 0L;
        euProduced += this.euBuffer;
        this.euBuffer = 0L;
        for (ConfigurableFluidStack configurableFluidStack : fluidInputs) {
            Fluid fluid = ((FluidVariant)configurableFluidStack.getResource()).getFluid();
            if (!this.fluidEUProductionMap.accept(fluid) || configurableFluidStack.getAmount() <= 0L) continue;
            long fuelEu = this.fluidEUProductionMap.getEuProduction(fluid);
            long usedDroplets = Math.min((maxEuProduced - euProduced + fuelEu - 1L) / fuelEu, configurableFluidStack.getAmount());
            configurableFluidStack.decrement(usedDroplets);
            if ((euProduced += usedDroplets * fuelEu) < maxEuProduced) continue;
            this.euBuffer += euProduced - maxEuProduced;
            return maxEuProduced;
        }
        for (ConfigurableItemStack configurableItemStack : itemInputs) {
            Item fuel = ((ItemVariant)configurableItemStack.getResource()).getItem();
            if (!this.itemEUProductionMap.accept(fuel) || configurableItemStack.getAmount() <= 0L || this.itemEUProductionMap.isStandardFuels() && !ItemStackHelper.consumeFuel(configurableItemStack, true)) continue;
            long fuelEU = this.itemEUProductionMap.getEuProduction(fuel);
            long usedItem = Math.min((maxEuProduced - euProduced + fuelEU - 1L) / fuelEU, configurableItemStack.getAmount());
            euProduced += fuelEU * usedItem;
            if (this.itemEUProductionMap.isStandardFuels()) {
                ItemStackHelper.consumeFuel(configurableItemStack, false);
            } else {
                configurableItemStack.decrement(usedItem);
            }
            if (euProduced < maxEuProduced) continue;
            this.euBuffer += euProduced - maxEuProduced;
            return maxEuProduced;
        }
        return euProduced;
    }

    public List<Component> getTooltips() {
        Object entry;
        List<EUProductionMap.InformationEntry<Fluid>> informationEntries;
        ArrayList<Component> returnList = new ArrayList<Component>();
        returnList.add((Component)new MITooltips.Line(MIText.MaxEuProduction).arg(this.maxEuProduction, MITooltips.EU_PER_TICK_PARSER).build());
        if (this.fluidEUProductionMap.getNumberOfFuel() != NumberOfFuel.NONE) {
            if (this.fluidEUProductionMap.isStandardFuels()) {
                returnList.add((Component)new MITooltips.Line(MIText.AcceptAnyFluidFuels).build());
            } else {
                informationEntries = this.fluidEUProductionMap.getAllAcceptedWithEU();
                if (informationEntries.size() == 1) {
                    entry = informationEntries.iterator().next();
                    returnList.add((Component)new MITooltips.Line(MIText.AcceptSingleFluid).arg(((EUProductionMap.InformationEntry)entry).variant).arg(((EUProductionMap.InformationEntry)entry).eu, MITooltips.EU_PARSER).build());
                } else if (informationEntries.size() > 1) {
                    returnList.add((Component)new MITooltips.Line(MIText.ConsumesTheFollowing).build());
                    for (EUProductionMap.InformationEntry<Fluid> entry2 : informationEntries) {
                        returnList.add((Component)new MITooltips.Line(MIText.AcceptFollowingFluidEntry).arg(entry2.variant).arg(entry2.eu, MITooltips.EU_PARSER).build());
                    }
                }
            }
        }
        if (this.itemEUProductionMap.getNumberOfFuel() != NumberOfFuel.NONE) {
            if (this.itemEUProductionMap.isStandardFuels()) {
                returnList.add((Component)new MITooltips.Line(MIText.AcceptAnyItemFuels).build());
            } else {
                informationEntries = this.itemEUProductionMap.getAllAcceptedWithEU();
                if (informationEntries.size() == 1) {
                    entry = informationEntries.iterator().next();
                    returnList.add((Component)new MITooltips.Line(MIText.AcceptSingleItem).arg(((EUProductionMap.InformationEntry)entry).variant).arg(((EUProductionMap.InformationEntry)entry).eu, MITooltips.EU_PARSER).build());
                } else {
                    returnList.add((Component)new MITooltips.Line(MIText.ConsumesTheFollowing).build());
                    for (EUProductionMap.InformationEntry<Fluid> entry2 : informationEntries) {
                        returnList.add((Component)new MITooltips.Line(MIText.AcceptFollowingItemEntry).arg(entry2.variant).arg(entry2.eu, MITooltips.EU_PARSER).build());
                    }
                }
            }
        }
        return returnList;
    }

    public static EUProductionMap<Item> itemFuels() {
        return new EUProductionMap<Item>(){

            @Override
            public long getEuProduction(Item variant) {
                int burnTime = variant.getDefaultInstance().getBurnTime(null);
                return burnTime <= 0 ? 0L : (long)burnTime * 20L;
            }

            @Override
            public boolean isStandardFuels() {
                return true;
            }

            @Override
            public List<Item> getAllAccepted() {
                throw new UnsupportedOperationException("The list of accepted items is not available for standard fuels");
            }
        };
    }

    public static EUProductionMap<Fluid> fluidFuels() {
        return new EUProductionMap<Fluid>(){

            @Override
            public long getEuProduction(Fluid variant) {
                return FluidFuel.getEu(variant);
            }

            @Override
            public boolean isStandardFuels() {
                return true;
            }

            @Override
            public List<Fluid> getAllAccepted() {
                throw new UnsupportedOperationException("The list of accepted fluids is not available for fluid fuels");
            }
        };
    }

    public static interface EUProductionMap<T> {
        public long getEuProduction(T var1);

        default public boolean isStandardFuels() {
            return false;
        }

        default public boolean accept(T variant) {
            return this.getEuProduction(variant) != 0L;
        }

        default public NumberOfFuel getNumberOfFuel() {
            if (this.isStandardFuels()) {
                return NumberOfFuel.MANY;
            }
            if (this.getAllAccepted().size() == 1) {
                return NumberOfFuel.SINGLE;
            }
            if (this.getAllAccepted().size() == 0) {
                return NumberOfFuel.NONE;
            }
            return NumberOfFuel.MANY;
        }

        public static <T> EUProductionMap<T> empty() {
            return new EUProductionMap<T>(){

                @Override
                public long getEuProduction(T variant) {
                    return 0L;
                }

                @Override
                public List<T> getAllAccepted() {
                    return List.of();
                }
            };
        }

        public List<T> getAllAccepted();

        default public List<InformationEntry<T>> getAllAcceptedWithEU() {
            return this.getAllAccepted().stream().map(variant -> new InformationEntry<Object>(this.getEuProduction(variant), variant)).sorted(Comparator.comparingLong(InformationEntry::eu)).collect(Collectors.toList());
        }

        public record InformationEntry<T>(long eu, T variant) {
        }
    }

    public static enum NumberOfFuel {
        NONE,
        SINGLE,
        MANY;

    }

    public static class EuProductionMapBuilder<T> {
        private final Map<ResourceLocation, Long> map = new HashMap<ResourceLocation, Long>();
        private final DefaultedRegistry<T> registryAccess;

        public EuProductionMapBuilder(DefaultedRegistry<T> registryAccess) {
            this.registryAccess = registryAccess;
        }

        public EuProductionMapBuilder<T> add(ResourceLocation resourceLocation, long eu) {
            this.map.put(resourceLocation, eu);
            return this;
        }

        public EUProductionMap<T> build() {
            return new EUProductionMap<T>(){

                @Override
                public long getEuProduction(T variant) {
                    return map.getOrDefault(registryAccess.getKey(variant), 0L);
                }

                @Override
                public List<T> getAllAccepted() {
                    return map.keySet().stream().map(arg_0 -> registryAccess.get(arg_0)).collect(Collectors.toList());
                }
            };
        }
    }
}

