/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe;

import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public abstract class ProxyableMachineRecipeType
extends MachineRecipeType {
    private long lastUpdate = 0L;
    private static final long UPDATE_INTERVAL = 20000L;
    private final List<RecipeHolder<MachineRecipe>> recipeList = new ArrayList<RecipeHolder<MachineRecipe>>();

    public ProxyableMachineRecipeType(ResourceLocation id) {
        super(id);
    }

    protected abstract void fillRecipeList(Level var1, List<RecipeHolder<MachineRecipe>> var2);

    @Override
    public final Collection<RecipeHolder<MachineRecipe>> getRecipesWithoutCache(Level level) {
        ArrayList<RecipeHolder<MachineRecipe>> recipes = new ArrayList<RecipeHolder<MachineRecipe>>();
        this.fillRecipeList(level, recipes);
        return recipes;
    }

    @Override
    public final Collection<RecipeHolder<MachineRecipe>> getRecipesWithCache(ServerLevel level) {
        long time = System.currentTimeMillis();
        if (time - this.lastUpdate > 20000L) {
            this.lastUpdate = time;
            this.recipeList.clear();
            this.fillRecipeList((Level)level, this.recipeList);
        }
        return this.recipeList;
    }
}

