/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials;

import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.part.MaterialItemPart;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.PartTemplate;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.materials.recipe.builder.MaterialRecipeBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.minecraft.data.recipes.RecipeOutput;
import org.jetbrains.annotations.Nullable;

public final class MaterialBuilder {
    private final Map<PartKey, MaterialItemPart> partsMap = new TreeMap<PartKey, MaterialItemPart>();
    private final Map<MaterialProperty<?>, Object> properties = new IdentityHashMap();
    private final String englishName;
    private final String materialName;
    private final Queue<RecipeAction> recipesActions = new LinkedList<RecipeAction>();

    public MaterialBuilder(String englishName, String materialName) {
        this.englishName = englishName;
        this.materialName = materialName;
        for (MaterialProperty<?> prop : MaterialProperty.PROPERTIES) {
            this.properties.put(prop, prop.defaultValue);
        }
    }

    public String getMaterialName() {
        return this.materialName;
    }

    public <T> MaterialBuilder set(MaterialProperty<T> prop, T value) {
        this.properties.put(prop, value);
        return this;
    }

    public MaterialBuilder addParts(PartTemplate ... providers) {
        for (PartTemplate provider : providers) {
            this.addPart(provider.create(this.materialName, this.englishName));
        }
        return this;
    }

    public MaterialBuilder addMaterialItemParts(MaterialItemPart ... parts) {
        for (MaterialItemPart part : parts) {
            this.addPart(part);
        }
        return this;
    }

    public MaterialBuilder addParts(List<?> parts) {
        for (Object part : parts) {
            if (part instanceof MaterialItemPart) {
                MaterialItemPart itemPart = (MaterialItemPart)part;
                this.addMaterialItemParts(itemPart);
                continue;
            }
            if (part instanceof PartTemplate) {
                PartTemplate template = (PartTemplate)part;
                this.addMaterialItemParts(template.create(this.materialName, this.englishName));
                continue;
            }
            throw new IllegalArgumentException("Invalid part type: " + String.valueOf(part.getClass()));
        }
        return this;
    }

    private void addPart(MaterialItemPart part) {
        if (this.partsMap.put(part.key(), part) != null) {
            throw new IllegalStateException("Part " + String.valueOf(part.key()) + " is already registered for this material! (" + this.materialName + ")");
        }
    }

    @SafeVarargs
    public final MaterialBuilder addRecipes(final Consumer<RecipeContext> ... consumers) {
        this.recipesActions.add(new RecipeAction(this){

            @Override
            void apply(RecipeContext recipeContext) {
                for (Consumer consumer : consumers) {
                    consumer.accept(recipeContext);
                }
            }
        });
        return this;
    }

    public MaterialBuilder cancelRecipes(final String ... recipeIds) {
        this.recipesActions.add(new RecipeAction(this){

            @Override
            void apply(RecipeContext context) {
                for (String recipeId : recipeIds) {
                    context.removeRecipe(recipeId);
                }
            }
        });
        return this;
    }

    public final Material build(RegisteringEvent ... events) {
        PartContext context = new PartContext();
        for (MaterialItemPart part : this.partsMap.values()) {
            part.register(context);
        }
        for (RegisteringEvent event : events) {
            event.onRegister(context);
        }
        return new Material(this.materialName, this.properties, Collections.unmodifiableMap(this.partsMap), this::buildRecipes);
    }

    public void buildRecipes(RecipeOutput output) {
        HashMap<String, MaterialRecipeBuilder> recipesMap = new HashMap<String, MaterialRecipeBuilder>();
        RecipeContext recipeContext = new RecipeContext(recipesMap);
        for (RecipeAction action : this.recipesActions) {
            action.apply(recipeContext);
        }
        for (MaterialRecipeBuilder builder : recipesMap.values()) {
            builder.save(output);
        }
    }

    public class PartContext {
        public String getMaterialName() {
            return MaterialBuilder.this.materialName;
        }

        public String getMaterialEnglishName() {
            return MaterialBuilder.this.englishName;
        }

        public MaterialItemPart getMaterialPart(PartKeyProvider part) {
            return MaterialBuilder.this.partsMap.get(part.key());
        }

        public <T> T get(MaterialProperty<T> prop) {
            return (T)MaterialBuilder.this.properties.get(prop);
        }
    }

    @FunctionalInterface
    public static interface RegisteringEvent {
        public void onRegister(PartContext var1);
    }

    public class RecipeContext {
        private final Map<String, MaterialRecipeBuilder> recipesMap;

        public RecipeContext(Map<String, MaterialRecipeBuilder> recipesMap) {
            this.recipesMap = recipesMap;
        }

        public void addRecipe(MaterialRecipeBuilder builder) {
            if (this.recipesMap.containsKey(builder.getRecipeId())) {
                if (this.recipesMap.get(builder.getRecipeId()).isCanceled()) {
                    this.recipesMap.remove(builder.getRecipeId());
                } else {
                    throw new IllegalStateException("Duplicate registration of recipe " + builder.getRecipeId() + " for Material : " + this.getMaterialName());
                }
            }
            this.recipesMap.put(builder.getRecipeId(), builder);
        }

        public void removeRecipe(String recipeId) {
            if (this.recipesMap.remove(recipeId) == null) {
                throw new IllegalArgumentException("Recipe does not exist and cannot be cancelled: " + recipeId + " for Material : " + MaterialBuilder.this.materialName);
            }
        }

        @Nullable
        public MaterialItemPart getPart(PartKeyProvider part) {
            return MaterialBuilder.this.partsMap.get(part.key());
        }

        public boolean hasInternalPart(PartKeyProvider partKey) {
            MaterialItemPart part = this.getPart(partKey);
            return part != null && part.isInternal();
        }

        public String getMaterialName() {
            return MaterialBuilder.this.materialName;
        }

        public <T> T get(MaterialProperty<T> prop) {
            return (T)MaterialBuilder.this.properties.get(prop);
        }
    }

    public abstract class RecipeAction {
        public RecipeAction(MaterialBuilder this$0) {
        }

        abstract void apply(RecipeContext var1);
    }
}

