/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.network.machines;

import aztech.modern_industrialization.machines.gui.MachineMenuCommon;
import aztech.modern_industrialization.network.BasePacket;
import aztech.modern_industrialization.network.MIStreamCodecs;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record MachineComponentSyncPacket(int syncId, int componentIndex, byte[] data) implements BasePacket
{
    public static final StreamCodec<ByteBuf, MachineComponentSyncPacket> STREAM_CODEC = StreamCodec.composite(MIStreamCodecs.BYTE, MachineComponentSyncPacket::syncId, (StreamCodec)ByteBufCodecs.VAR_INT, MachineComponentSyncPacket::componentIndex, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, MachineComponentSyncPacket::data, MachineComponentSyncPacket::new);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(BasePacket.Context ctx) {
        ctx.assertOnClient();
        if (ctx.getPlayer().containerMenu.containerId == this.syncId) {
            MachineMenuCommon screenHandler = (MachineMenuCommon)ctx.getPlayer().containerMenu;
            RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])this.data), ctx.getPlayer().registryAccess());
            try {
                screenHandler.readClientComponentSyncData(this.componentIndex, buf);
            }
            finally {
                buf.release();
            }
        }
    }
}

