/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class IOFluidHandler
implements IFluidHandler {
    private final IFluidHandler handler;
    private final boolean allowInsert;
    private final boolean allowExtract;

    public IOFluidHandler(IFluidHandler handler, boolean allowInsert, boolean allowExtract) {
        this.handler = handler;
        this.allowInsert = allowInsert;
        this.allowExtract = allowExtract;
    }

    public int getTanks() {
        return this.handler.getTanks();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.handler.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.handler.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.allowInsert && this.handler.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.allowInsert ? this.handler.fill(resource, action) : 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.allowExtract ? this.handler.drain(resource, action) : FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.allowExtract ? this.handler.drain(maxDrain, action) : FluidStack.EMPTY;
    }
}

