/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.rei;

import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.compat.viewer.impl.rei.ReiSlotUtil;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Nullable;

class ViewerCategoryRei<D>
implements DisplayCategory<ViewerDisplay> {
    public final ViewerCategory<D> wrapped;
    public final CategoryIdentifier<ViewerDisplay> identifier;
    private final Renderer icon;

    public ViewerCategoryRei(ViewerCategory<D> wrapped) {
        Renderer renderer;
        this.wrapped = wrapped;
        this.identifier = CategoryIdentifier.of((ResourceLocation)wrapped.id);
        ViewerCategory.Icon icon = wrapped.icon;
        if (icon instanceof ViewerCategory.Icon.Stack) {
            ViewerCategory.Icon.Stack stack = (ViewerCategory.Icon.Stack)icon;
            renderer = EntryStacks.of((ItemStack)stack.stack());
        } else {
            renderer = (guiGraphics, bounds, mouseX, mouseY, delta) -> {
                ViewerCategory.Icon.Texture texture = (ViewerCategory.Icon.Texture)wrapped.icon;
                guiGraphics.blit(texture.loc(), bounds.x - 1, bounds.y - 1, (float)texture.u(), (float)texture.v(), 18, 18, 256, 256);
            };
        }
        this.icon = renderer;
    }

    public CategoryIdentifier<? extends ViewerDisplay> getCategoryIdentifier() {
        return this.identifier;
    }

    public Component getTitle() {
        return this.wrapped.title;
    }

    public int getDisplayWidth(ViewerDisplay display) {
        return this.wrapped.width;
    }

    public int getDisplayHeight() {
        return this.wrapped.height;
    }

    public Renderer getIcon() {
        return this.icon;
    }

    public void registerRecipes(DisplayRegistry registry) {
        this.wrapped.buildRecipes(registry.getRecipeManager(), Minecraft.getInstance().level.registryAccess(), r -> registry.add((Display)this.makeDisplay(r)));
    }

    private void processLayout(D recipe, final List<IngredientBuilder> inputs, final List<IngredientBuilder> outputs) {
        this.wrapped.buildLayout(recipe, new ViewerCategory.LayoutBuilder(){

            @Override
            public ViewerCategory.SlotBuilder inputSlot(int x, int y) {
                IngredientBuilder ing = new IngredientBuilder(x, y, true);
                inputs.add(ing);
                return ing;
            }

            @Override
            public ViewerCategory.SlotBuilder outputSlot(int x, int y) {
                IngredientBuilder ing = new IngredientBuilder(x, y, false);
                outputs.add(ing);
                return ing;
            }

            @Override
            public void invisibleInput(ItemStack item) {
                IngredientBuilder ing = new IngredientBuilder(0, 0, true);
                ing.item(item);
                ing.isVisible = false;
                inputs.add(ing);
            }

            @Override
            public void invisibleOutput(ItemStack item) {
                IngredientBuilder ing = new IngredientBuilder(0, 0, false);
                ing.item(item);
                ing.isVisible = false;
                outputs.add(ing);
            }

            @Override
            public void scrollableSlots(int cols, int rows, List<ItemStack> stacks) {
                int x = ViewerCategoryRei.this.wrapped.width / 2 - 18 * cols / 2 + 1;
                int y = ViewerCategoryRei.this.wrapped.height - rows * 18 - 3;
                int index = 0;
                for (int row = 0; row < rows; ++row) {
                    for (int col = 0; col < cols; ++col) {
                        int ix = x + col * 18;
                        int iy = y + row * 18;
                        ViewerCategory.SlotBuilder slot = this.inputSlot(ix, iy);
                        if (index < stacks.size()) {
                            slot.item(stacks.get(index));
                        }
                        ++index;
                    }
                }
            }
        });
    }

    private ViewerDisplay makeDisplay(D recipe) {
        ArrayList<IngredientBuilder> inputs = new ArrayList<IngredientBuilder>();
        ArrayList<IngredientBuilder> outputs = new ArrayList<IngredientBuilder>();
        this.processLayout(recipe, inputs, outputs);
        return new ViewerDisplay(this.identifier, ViewerCategoryRei.convert(inputs), ViewerCategoryRei.convert(outputs), recipe);
    }

    private static List<EntryIngredient> convert(List<IngredientBuilder> ings) {
        ArrayList<EntryIngredient> ingredients = new ArrayList<EntryIngredient>();
        for (IngredientBuilder ing : ings) {
            ingredients.add(EntryIngredient.of(ing.ing));
        }
        return ingredients;
    }

    public List<Widget> setupDisplay(ViewerDisplay display, final Rectangle bounds) {
        final ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        this.wrapped.buildWidgets(display.recipe, new ViewerCategory.WidgetList(){

            @Override
            public void text(Component text, float x, float y, ViewerCategory.TextAlign align, boolean shadow, boolean overrideColor, @Nullable Component tooltip) {
                Label label = Widgets.createLabel((Point)new Point((double)((float)bounds.x + x), (double)((float)bounds.y + y)), (Component)text);
                switch (align) {
                    case LEFT: {
                        label.leftAligned();
                        break;
                    }
                    case CENTER: {
                        label.centered();
                        break;
                    }
                    case RIGHT: {
                        label.rightAligned();
                    }
                }
                label.shadow(shadow);
                if (overrideColor) {
                    label.color(-12566464, -4473925);
                }
                if (tooltip != null) {
                    label.tooltip(new Component[]{tooltip});
                }
                widgets.add(label);
            }

            @Override
            public void arrow(int x, int y) {
                widgets.add(Widgets.createArrow((Point)new Point(bounds.x + x, bounds.y + y)));
            }

            @Override
            public void texture(ResourceLocation loc, int x, int y, int u, int v, int width, int height) {
                widgets.add(Widgets.createTexturedWidget((ResourceLocation)loc, (int)(bounds.x + x), (int)(bounds.y + y), (float)u, (float)v, (int)width, (int)height));
            }

            @Override
            public void drawable(Consumer<GuiGraphics> widget) {
                widgets.add(Widgets.createDrawableWidget((guiGraphics, mouseX, mouseY, delta) -> {
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate((float)bounds2.x, (float)bounds2.y, 0.0f);
                    widget.accept(guiGraphics);
                    guiGraphics.pose().popPose();
                }));
            }

            @Override
            public void tooltip(int x, int y, int w, int h, List<Component> tooltip) {
                widgets.add(Widgets.createDrawableWidget((matrices, reiMouseX, reiMouseY, delta) -> {
                    int mouseX = reiMouseX - bounds2.x;
                    int mouseY = reiMouseY - bounds2.y;
                    if (mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h) {
                        Tooltip.create((Collection)tooltip).queue();
                    }
                }));
            }

            @Override
            public void scrollableSlots(int cols, int rows, List<ItemStack> stacks) {
            }
        });
        ArrayList<IngredientBuilder> inputs = new ArrayList<IngredientBuilder>();
        ArrayList<IngredientBuilder> outputs = new ArrayList<IngredientBuilder>();
        this.processLayout(display.recipe, inputs, outputs);
        for (IngredientBuilder input : inputs) {
            ViewerCategoryRei.processIngredient(widgets, input, true, bounds);
        }
        for (IngredientBuilder output : outputs) {
            ViewerCategoryRei.processIngredient(widgets, output, false, bounds);
        }
        return widgets;
    }

    private static Widget createFluidSlotBackground(Point point) {
        return Widgets.createDrawableWidget((guiGraphics, mouseX, mouseY, delta) -> guiGraphics.blit(MachineScreen.SLOT_ATLAS, point.x - 1, point.y - 1, 18, 0, 18, 18));
    }

    private static void processIngredient(List<Widget> widgets, IngredientBuilder ing, boolean isInput, Rectangle bounds) {
        if (!ing.isVisible) {
            return;
        }
        Point point = new Point(bounds.x + ing.x, bounds.y + ing.y);
        Slot slot = Widgets.createSlot((Point)point).entries(ing.ing);
        if (isInput) {
            slot.markInput();
        } else {
            slot.markOutput();
        }
        if (!ing.hasBackground) {
            slot.disableBackground();
        }
        if (ing.isFluid) {
            widgets.add(ViewerCategoryRei.createFluidSlotBackground(point));
        }
        widgets.add((Widget)slot);
    }

    public class ViewerDisplay
    implements Display {
        private final CategoryIdentifier<ViewerDisplay> identifier;
        private final List<EntryIngredient> inputs;
        private final List<EntryIngredient> outputs;
        final D recipe;

        public ViewerDisplay(CategoryIdentifier<ViewerDisplay> identifier, List<EntryIngredient> inputs, List<EntryIngredient> outputs, D recipe) {
            this.identifier = identifier;
            this.inputs = inputs;
            this.outputs = outputs;
            this.recipe = recipe;
        }

        public List<EntryIngredient> getInputEntries() {
            return this.inputs;
        }

        public List<EntryIngredient> getOutputEntries() {
            return this.outputs;
        }

        public CategoryIdentifier<?> getCategoryIdentifier() {
            return this.identifier;
        }

        public Optional<ResourceLocation> getDisplayLocation() {
            return Optional.of(ViewerCategoryRei.this.wrapped.getRecipeId(this.recipe));
        }
    }

    private static class IngredientBuilder
    implements ViewerCategory.SlotBuilder {
        private final int x;
        private final int y;
        private final boolean input;
        private final List<EntryStack<?>> ing;
        private boolean isFluid = false;
        private boolean hasBackground = true;
        private boolean isVisible = true;

        IngredientBuilder(int x, int y, boolean input) {
            this.x = x;
            this.y = y;
            this.input = input;
            this.ing = new ArrayList();
        }

        @Override
        public ViewerCategory.SlotBuilder variant(TransferVariant<?> variant) {
            if (variant instanceof ItemVariant) {
                ItemVariant item = (ItemVariant)variant;
                this.item(item.toStack());
            } else if (variant instanceof FluidVariant) {
                FluidVariant fluid = (FluidVariant)variant;
                this.isFluid = true;
                this.hasBackground = false;
                if (!fluid.isBlank()) {
                    this.ing.add(ReiSlotUtil.createFluidNoAmount(fluid));
                }
            } else {
                throw new IllegalArgumentException("Unknown variant type: " + String.valueOf(variant.getClass()));
            }
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder fluid(FluidVariant fluid, long amount, float probability) {
            this.isFluid = true;
            this.hasBackground = false;
            this.ing.add(ReiSlotUtil.createFluidEntryStack(fluid, amount, probability, this.input));
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder fluid(FluidIngredient ingredient, long amount, float probability) {
            this.isFluid = true;
            this.hasBackground = false;
            for (FluidStack fs : ingredient.getStacks()) {
                this.ing.add(ReiSlotUtil.createFluidEntryStack(FluidVariant.of(fs), amount, probability, this.input));
            }
            return this;
        }

        private ViewerCategory.SlotBuilder items(List<ItemStack> stacks, float probability) {
            for (ItemStack stack : stacks) {
                this.ing.add(EntryStacks.of((ItemStack)stack).tooltip(ReiSlotUtil.getProbabilitySetting(probability, this.input)));
            }
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder item(ItemStack stack, float probability) {
            return this.items(List.of(stack), probability);
        }

        @Override
        public ViewerCategory.SlotBuilder ingredient(Ingredient ingredient, long amount, float probability) {
            return this.items(Stream.of(ingredient.getItems()).map(i -> {
                ItemStack cp = i.copy();
                cp.setCount((int)amount);
                return cp;
            }).toList(), probability);
        }

        @Override
        public ViewerCategory.SlotBuilder removeBackground() {
            this.hasBackground = false;
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder markCatalyst() {
            return this;
        }
    }
}

