/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIFluidStorage;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.MIItemStorage;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.AutoExtract;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.util.Tickable;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;

public class ReplicatorMachineBlockEntity
extends MachineBlockEntity
implements Tickable {
    private final IsActiveComponent isActiveComponent = new IsActiveComponent();
    private final MachineInventoryComponent inventoryComponent;
    private final RedstoneControlComponent redstoneControl = new RedstoneControlComponent();
    private int progressTick = 0;
    public static final TagKey<Item> BLACKLISTED = ItemTags.create((ResourceLocation)MI.id("replicator_blacklist"));
    public static final TagKey<Fluid> BLACKLISTED_FLUIDS = FluidTags.create((ResourceLocation)MI.id("replicator_blacklist"));

    public ReplicatorMachineBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder("replicator", true).build(), new OrientationComponent.Params(true, true, false));
        ProgressBar.Parameters progressBarParams = new ProgressBar.Parameters(85, 34, "arrow");
        long capacity = 256000L;
        List<ConfigurableFluidStack> fluidInput = Collections.singletonList(ConfigurableFluidStack.lockedInputSlot(capacity, MIFluids.UU_MATTER.asFluid()));
        List<ConfigurableItemStack> itemInputs = Collections.singletonList(ConfigurableItemStack.standardInputSlot());
        List<ConfigurableItemStack> itemOutputs = Collections.singletonList(ConfigurableItemStack.standardOutputSlot());
        SlotPositions fluidSlotPositions = new SlotPositions.Builder().addSlot(35, 35).build();
        SlotPositions itemSlotPositions = new SlotPositions.Builder().addSlot(60, 35).addSlot(115, 35).build();
        this.inventoryComponent = new MachineInventoryComponent(itemInputs, itemOutputs, fluidInput, Collections.emptyList(), itemSlotPositions, fluidSlotPositions);
        this.registerComponents(this.isActiveComponent, this.inventoryComponent, this.redstoneControl, new IComponent(){

            @Override
            public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
                tag.putInt("progressTick", ReplicatorMachineBlockEntity.this.progressTick);
            }

            @Override
            public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
                ReplicatorMachineBlockEntity.this.progressTick = tag.getInt("progressTick");
            }
        });
        this.registerGuiComponent(new ProgressBar.Server(progressBarParams, () -> Float.valueOf((float)this.progressTick / 20.0f)));
        this.registerGuiComponent(new AutoExtract.Server(this.orientation, false));
        this.registerGuiComponent(new SlotPanel.Server(this).withRedstoneControl(this.redstoneControl));
    }

    @Override
    public MIInventory getInventory() {
        return this.inventoryComponent.inventory;
    }

    @Override
    protected MachineModelClientData getMachineModelData() {
        MachineModelClientData data = new MachineModelClientData();
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    private static boolean canReplicate(ItemStack stack) {
        IFluidHandlerItem fluidItem;
        if (stack.is(BLACKLISTED)) {
            return false;
        }
        IItemHandler itemHandler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (itemHandler != null) {
            int slots = itemHandler.getSlots();
            for (int i = 0; i < slots; ++i) {
                if (itemHandler.getStackInSlot(i).isEmpty()) continue;
                return false;
            }
        }
        if ((fluidItem = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)) != null) {
            for (int tank = 0; tank < fluidItem.getTanks(); ++tank) {
                if (!fluidItem.getFluidInTank(tank).is(BLACKLISTED_FLUIDS)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean replicationStep(boolean simulate) {
        ItemVariant itemVariant = (ItemVariant)this.inventoryComponent.getItemInputs().get(0).getResource();
        if (!itemVariant.isBlank()) {
            if (!ReplicatorMachineBlockEntity.canReplicate(itemVariant.toStack())) {
                return false;
            }
            try (Transaction tx = Transaction.openOuter();){
                MIItemStorage itemStorage = new MIItemStorage(this.inventoryComponent.getItemOutputs());
                MIFluidStorage fluidStorage = new MIFluidStorage(this.inventoryComponent.getFluidInputs());
                long inserted = itemStorage.insertAllSlot(itemVariant, 1L, tx);
                long uuMatterExtraced = fluidStorage.extractAllSlot(MIFluids.UU_MATTER.variant(), 100L, tx);
                if (inserted == 1L && uuMatterExtraced == 100L) {
                    if (!simulate) {
                        tx.commit();
                    }
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide) {
            if (!this.redstoneControl.doAllowNormalOperation(this)) {
                this.isActiveComponent.updateActive(false, this);
            } else if (this.replicationStep(true)) {
                ++this.progressTick;
                this.isActiveComponent.updateActive(true, this);
                if (this.progressTick == 20) {
                    this.replicationStep(false);
                    this.progressTick = 0;
                }
            } else {
                this.isActiveComponent.updateActive(false, this);
                this.progressTick = 0;
            }
            if (this.orientation.extractItems) {
                this.inventoryComponent.inventory.autoExtractItems(this.level, this.worldPosition, this.orientation.outputDirection);
            }
            this.setChanged();
        }
    }
}

