/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.api.machine.component.EnergyAccess;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EnergyComponent
implements IComponent.ServerOnly,
EnergyAccess {
    private long storedEu;
    private final Supplier<Long> capacity;
    private final BlockEntity blockEntity;

    public EnergyComponent(BlockEntity blockEntity, Supplier<Long> capacity) {
        this.capacity = capacity;
        this.blockEntity = blockEntity;
    }

    public EnergyComponent(BlockEntity blockEntity, long capacity) {
        this.capacity = () -> capacity;
        this.blockEntity = blockEntity;
    }

    @Override
    public long getEu() {
        return Math.min(this.storedEu, this.capacity.get());
    }

    @Override
    public long getCapacity() {
        return this.capacity.get();
    }

    public long getRemainingCapacity() {
        return this.capacity.get() - this.getEu();
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putLong("storedEu", this.getEu());
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.setEu(tag.getLong("storedEu"), false);
    }

    private void setEu(long eu, boolean update) {
        this.storedEu = Math.min(eu, this.capacity.get());
        if (update) {
            this.blockEntity.setChanged();
        }
    }

    public long consumeEu(long max, Simulation simulation) {
        Preconditions.checkArgument((max >= 0L ? 1 : 0) != 0, (Object)"May not consume < 0 energy.");
        long ext = Math.min(max, this.getEu());
        if (simulation.isActing()) {
            this.setEu(this.getEu() - ext, true);
        }
        return ext;
    }

    public long insertEu(long max, Simulation simulation) {
        Preconditions.checkArgument((max >= 0L ? 1 : 0) != 0, (Object)"May not insert < 0 energy.");
        long ext = Math.min(max, this.capacity.get() - this.getEu());
        if (simulation.isActing()) {
            this.setEu(this.getEu() + ext, true);
        }
        return ext;
    }

    public MIEnergyStorage buildInsertable(final Predicate<CableTier> canInsert) {
        return new EnergyStorage(){

            public long receive(long maxReceive, boolean simulate) {
                return EnergyComponent.this.insertEu(maxReceive, simulate ? Simulation.SIMULATE : Simulation.ACT);
            }

            public boolean canReceive() {
                return true;
            }

            public long extract(long maxExtract, boolean simulate) {
                return 0L;
            }

            public boolean canExtract() {
                return false;
            }

            @Override
            public boolean canConnect(CableTier cableTier) {
                return canInsert.test(cableTier);
            }
        };
    }

    public MIEnergyStorage buildExtractable(final Predicate<CableTier> canExtract) {
        return new EnergyStorage(){

            public long receive(long maxReceive, boolean simulate) {
                return 0L;
            }

            public boolean canReceive() {
                return false;
            }

            public long extract(long maxExtract, boolean simulate) {
                return EnergyComponent.this.consumeEu(maxExtract, simulate ? Simulation.SIMULATE : Simulation.ACT);
            }

            public boolean canExtract() {
                return true;
            }

            @Override
            public boolean canConnect(CableTier cableTier) {
                return canExtract.test(cableTier);
            }
        };
    }

    private abstract class EnergyStorage
    implements MIEnergyStorage {
        private EnergyStorage() {
        }

        public long getAmount() {
            return EnergyComponent.this.storedEu;
        }

        public long getCapacity() {
            return EnergyComponent.this.capacity.get();
        }
    }
}

