/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public final class HatchType {
    private final ResourceLocation id;
    private final Either<Component, ResourceLocation> descriptionOrBlockId;

    HatchType(ResourceLocation id, Component description) {
        this.id = id;
        this.descriptionOrBlockId = Either.left((Object)description);
    }

    HatchType(ResourceLocation id, ResourceLocation blockId) {
        this.id = id;
        this.descriptionOrBlockId = Either.right((Object)blockId);
    }

    public ResourceLocation id() {
        return this.id;
    }

    public MutableComponent description() {
        return (MutableComponent)this.descriptionOrBlockId.map(Component::copy, id -> ((Block)BuiltInRegistries.BLOCK.get(id)).getName());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof HatchType)) return false;
        HatchType other = (HatchType)o;
        if (!this.id.equals((Object)other.id)) return false;
        return true;
    }
}

