/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.barrel;

import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlockEntity;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;

public class DeferredBarrelTextRenderer {
    private static final List<Entry> barrelsToRender = new ArrayList<Entry>();
    private static final MultiBufferSource.BufferSource immediate = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(128));

    public static void init() {
        NeoForge.EVENT_BUS.addListener(DeferredBarrelTextRenderer::render);
    }

    public static void enqueueBarrelForRendering(BlockPos pos, int sideMask, int itemNameColor) {
        barrelsToRender.add(new Entry(pos.immutable(), sideMask, itemNameColor));
    }

    private static void render(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        PoseStack matrices = event.getPoseStack();
        matrices.pushPose();
        Vec3 camPos = event.getCamera().getPosition();
        matrices.translate(-camPos.x, -camPos.y, -camPos.z);
        for (Entry entry : barrelsToRender) {
            BlockPos pos = entry.pos();
            int sideMask = entry.sideMask();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof BarrelBlockEntity)) continue;
            BarrelBlockEntity entity = (BarrelBlockEntity)blockEntity;
            matrices.pushPose();
            matrices.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            String amount = entity.behaviour.isCreative() ? "\u221e" : String.valueOf(entity.getAmount());
            ItemStack toRender = ((ItemVariant)entity.getResource()).toStack();
            for (int i = 0; i < 4; ++i) {
                if ((sideMask & 1 << i) == 0) continue;
                Font textRenderer = Minecraft.getInstance().font;
                Object itemName = toRender.getHoverName().getString();
                matrices.pushPose();
                matrices.translate(0.5, 1.14, 0.5);
                matrices.mulPose(Axis.YP.rotationDegrees((float)(2 - i) * 90.0f));
                matrices.translate(0.0, 0.15, -0.505);
                matrices.scale(-0.01f, -0.01f, -0.01f);
                int maxWidth = 100;
                if (textRenderer.width((String)itemName) > 100) {
                    itemName = textRenderer.plainSubstrByWidth((String)itemName, 100 - textRenderer.width("...")) + "...";
                }
                float xPosition = -textRenderer.width((String)itemName) / 2;
                textRenderer.drawInBatch((String)itemName, xPosition, 36.0f, entry.itemNameColor(), false, matrices.last().pose(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                matrices.popPose();
                matrices.pushPose();
                matrices.translate(0.5, 0.5, 0.5);
                matrices.mulPose(Axis.YP.rotationDegrees((float)(2 - i) * 90.0f));
                matrices.translate(0.0, 0.0875, -0.505);
                matrices.scale(-0.01f, -0.01f, -0.01f);
                xPosition = -textRenderer.width(amount) / 2;
                textRenderer.drawInBatch(amount, xPosition, 36.0f, 0, false, matrices.last().pose(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                matrices.popPose();
            }
            matrices.popPose();
        }
        matrices.popPose();
        barrelsToRender.clear();
        immediate.endBatch();
    }

    private record Entry(BlockPos pos, int sideMask, int itemNameColor) {
    }
}

