/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.loot;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.datagen.loot.MIBlockLoot;
import aztech.modern_industrialization.definition.BlockDefinition;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class BlockLootTableProvider
extends BlockLootSubProvider {
    public BlockLootTableProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.VANILLA_SET, registries);
    }

    protected Iterable<Block> getKnownBlocks() {
        return MIBlock.BLOCK_DEFINITIONS.values().stream().filter(x -> x.blockLoot != null).map(BlockDefinition::asBlock).toList();
    }

    public void generate() {
        for (BlockDefinition<?> blockDefinition : MIBlock.BLOCK_DEFINITIONS.values()) {
            if (blockDefinition.blockLoot == null) continue;
            Object block = blockDefinition.asBlock();
            if (blockDefinition.blockLoot instanceof MIBlockLoot.DropSelf) {
                this.dropSelf((Block)block);
                continue;
            }
            MIBlockLoot mIBlockLoot = blockDefinition.blockLoot;
            if (!(mIBlockLoot instanceof MIBlockLoot.Ore)) continue;
            MIBlockLoot.Ore ore = (MIBlockLoot.Ore)mIBlockLoot;
            this.add((Block)block, this.createOreDrop((Block)block, (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)ore.loot()))));
        }
    }
}

