/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.fluid.MIFluid;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeBuilder;
import com.google.common.base.Preconditions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.level.material.Fluid;

public class PetrochemRecipesProvider
extends MIRecipesProvider {
    public PetrochemRecipesProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public void buildRecipes(RecipeOutput consumer) {
        this.generateDistillation(consumer, 12, 200, PetrochemRecipesProvider.f(MIFluids.CRUDE_OIL, 1000), PetrochemRecipesProvider.f(MIFluids.SULFURIC_LIGHT_FUEL, 500), PetrochemRecipesProvider.f(MIFluids.SULFURIC_HEAVY_FUEL, 200), PetrochemRecipesProvider.f(MIFluids.SULFURIC_NAPHTHA, 300));
        this.generateDistillation(consumer, 20, 200, PetrochemRecipesProvider.f(MIFluids.STEAM_CRACKED_HEAVY_FUEL, 1000), PetrochemRecipesProvider.f(MIFluids.LIGHT_FUEL, 500), PetrochemRecipesProvider.f(MIFluids.METHANE, 100), PetrochemRecipesProvider.f(MIFluids.BUTADIENE, 250), PetrochemRecipesProvider.f(MIFluids.BENZENE, 150));
        this.generateDistillation(consumer, 25, 200, PetrochemRecipesProvider.f(MIFluids.STEAM_CRACKED_LIGHT_FUEL, 1000), PetrochemRecipesProvider.f(MIFluids.METHANE, 200), PetrochemRecipesProvider.f(MIFluids.ACETYLENE, 100), PetrochemRecipesProvider.f(MIFluids.ETHYLENE, 300), PetrochemRecipesProvider.f(MIFluids.BUTADIENE, 200), PetrochemRecipesProvider.f(MIFluids.BENZENE, 200));
        this.generateDistillation(consumer, 15, 200, PetrochemRecipesProvider.f(MIFluids.STEAM_CRACKED_NAPHTHA, 1000), PetrochemRecipesProvider.f(MIFluids.METHANE, 150), PetrochemRecipesProvider.f(MIFluids.ACETYLENE, 50), PetrochemRecipesProvider.f(MIFluids.ETHYLENE, 250), PetrochemRecipesProvider.f(MIFluids.PROPENE, 75), PetrochemRecipesProvider.f(MIFluids.BUTADIENE, 125), PetrochemRecipesProvider.f(MIFluids.BENZENE, 150), PetrochemRecipesProvider.f(MIFluids.TOLUENE, 100), PetrochemRecipesProvider.f(MIFluids.ETHYLBENZENE, 100));
        this.generateDistillation(consumer, 10, 200, PetrochemRecipesProvider.f(MIFluids.SHALE_OIL, 1000), PetrochemRecipesProvider.f(MIFluids.HELIUM, 50), PetrochemRecipesProvider.f(MIFluids.SULFURIC_CRUDE_OIL, 450), PetrochemRecipesProvider.f(MIFluids.SULFURIC_NAPHTHA, 500));
        this.generateSulfuricPurification(consumer, MIFluids.CRUDE_OIL);
        this.generateSulfuricPurification(consumer, MIFluids.HEAVY_FUEL);
        this.generateSulfuricPurification(consumer, MIFluids.LIGHT_FUEL);
        this.generateSulfuricPurification(consumer, MIFluids.NAPHTHA);
        this.generatePolymerization(consumer, MIFluids.ETHYLENE, MIFluids.POLYETHYLENE);
        this.generatePolymerization(consumer, MIFluids.VINYL_CHLORIDE, MIFluids.POLYVINYL_CHLORIDE);
        this.generatePolymerization(consumer, MIFluids.CAPROLACTAM, MIFluids.NYLON);
        this.generatePolymerization(consumer, MIFluids.ACRYLIC_ACID, MIFluids.ACRYLIC_GLUE);
        this.generatePolymerization(consumer, MIFluids.STYRENE_BUTADIENE, MIFluids.STYRENE_BUTADIENE_RUBBER);
        this.generateSteamCracking(consumer, MIFluids.HEAVY_FUEL, MIFluids.STEAM_CRACKED_HEAVY_FUEL);
        this.generateSteamCracking(consumer, MIFluids.LIGHT_FUEL, MIFluids.STEAM_CRACKED_LIGHT_FUEL);
        this.generateSteamCracking(consumer, MIFluids.NAPHTHA, MIFluids.STEAM_CRACKED_NAPHTHA);
    }

    private void generateDistillation(RecipeOutput consumer, int eu, int duration, FluidEntry input, FluidEntry ... outputs) {
        String basePath = "petrochem/distillation/" + BuiltInRegistries.FLUID.getKey((Object)input.fluid).getPath() + "_";
        MachineRecipeBuilder full = new MachineRecipeBuilder(MIMachineRecipeTypes.DISTILLATION_TOWER, eu * outputs.length, duration);
        full.addFluidInput(input.fluid, input.amount);
        for (FluidEntry output : outputs) {
            full.addFluidOutput(output.fluid, output.amount);
        }
        full.offerTo(consumer, basePath + "full");
        for (int i = 0; i < outputs.length; ++i) {
            FluidEntry output = outputs[i];
            ((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.DISTILLERY, eu, duration).addFluidInput(input.fluid, input.amount)).addFluidOutput(output.fluid, output.amount)).offerTo(consumer, basePath + i);
        }
    }

    private void generateSulfuricPurification(RecipeOutput consumer, Fluid purifiedFluid) {
        String baseName = BuiltInRegistries.FLUID.getKey((Object)purifiedFluid).getPath();
        Fluid sulfuricFluid = (Fluid)BuiltInRegistries.FLUID.get(MI.id("sulfuric_" + baseName));
        Preconditions.checkArgument((boolean)(sulfuricFluid instanceof MIFluid));
        ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.CHEMICAL_REACTOR, 16, 400).addFluidInput(sulfuricFluid, 12000)).addFluidInput(MIFluids.HYDROGEN.asFluid(), 2000)).addFluidOutput(purifiedFluid, 12000)).addFluidOutput(MIFluids.SULFURIC_ACID.asFluid(), 2000)).offerTo(consumer, "petrochem/sulfuric_purification/" + baseName);
    }

    private void generateSulfuricPurification(RecipeOutput consumer, FluidLike purifiedFluid) {
        this.generateSulfuricPurification(consumer, purifiedFluid.asFluid());
    }

    private void generatePolymerization(RecipeOutput consumer, Fluid input, Fluid output) {
        String baseNameInput = BuiltInRegistries.FLUID.getKey((Object)input).getPath();
        for (PolymerizationKind kind : PolymerizationKind.values()) {
            ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.CHEMICAL_REACTOR, 12, 700).addItemInput("#c:tiny_dusts/" + kind.catalystMaterial, kind.inputTinyDust)).addFluidInput(input, 500)).addFluidOutput(output, kind.outputMillis)).offerTo(consumer, "petrochem/polymerization/" + baseNameInput + "_" + kind.name().toLowerCase());
        }
    }

    private void generatePolymerization(RecipeOutput consumer, FluidLike input, FluidLike output) {
        this.generatePolymerization(consumer, input.asFluid(), output.asFluid());
    }

    private void generateSteamCracking(RecipeOutput consumer, FluidLike input, FluidLike output) {
        ((MachineRecipeBuilder)((MachineRecipeBuilder)((MachineRecipeBuilder)new MachineRecipeBuilder(MIMachineRecipeTypes.CHEMICAL_REACTOR, 8, 100).addFluidInput(input, 1000)).addFluidInput(MIFluids.STEAM, 100)).addFluidOutput(output, 1000)).offerTo(consumer, "petrochem/steam_cracking/" + BuiltInRegistries.FLUID.getKey((Object)input.asFluid()).getPath());
    }

    private static FluidEntry f(Fluid fluid, int amount) {
        return new FluidEntry(fluid, amount);
    }

    private static FluidEntry f(FluidLike fluid, int amount) {
        return PetrochemRecipesProvider.f(fluid.asFluid(), amount);
    }

    private record FluidEntry(Fluid fluid, int amount) {
    }

    private static enum PolymerizationKind {
        LEAD("lead", 4, 300),
        CHROMIUM("chromium", 1, 700);

        private final String catalystMaterial;
        private final int inputTinyDust;
        private final int outputMillis;

        private PolymerizationKind(String catalystMaterial, int inputTinyDust, int outputMillis) {
            this.catalystMaterial = catalystMaterial;
            this.inputTinyDust = inputTinyDust;
            this.outputMillis = outputMillis;
        }
    }
}

