/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.definition;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.datagen.loot.MIBlockLoot;
import aztech.modern_industrialization.datagen.model.BaseModelProvider;
import aztech.modern_industrialization.definition.Definition;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.items.SortOrder;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.Nullable;

public class BlockDefinition<T extends Block>
extends Definition
implements ItemLike,
Supplier<T> {
    private final DeferredBlock<T> block;
    public final ItemDefinition<BlockItem> blockItem;
    public final BiConsumer<Block, BaseModelProvider> modelGenerator;
    @Nullable
    public final MIBlockLoot blockLoot;
    public final List<TagKey<Block>> tags;
    private BiConsumer<Block, Item> onBlockRegistrationEvent;

    public BlockDefinition(String englishName, DeferredBlock<T> block, BiFunction<? super T, Item.Properties, BlockItem> blockItemCtor, BiConsumer<Block, BaseModelProvider> modelGenerator, BiConsumer<Item, ItemModelProvider> itemModelGenerator, MIBlockLoot blockLoot, List<TagKey<Block>> tags, SortOrder sortOrder) {
        super(englishName, block.getId().getPath(), false);
        this.block = block;
        this.blockItem = MIItem.item(englishName, this.path(), s -> (BlockItem)blockItemCtor.apply((Object)block.get(), (Item.Properties)s), itemModelGenerator, sortOrder);
        this.modelGenerator = modelGenerator;
        this.blockLoot = blockLoot;
        this.tags = tags;
    }

    public BlockDefinition<T> withBlockRegistrationEvent(BiConsumer<Block, Item> onBlockRegistrationEvent) {
        this.onBlockRegistrationEvent = onBlockRegistrationEvent;
        return this;
    }

    public Item asItem() {
        if (this.blockItem != null) {
            return this.blockItem.asItem();
        }
        return null;
    }

    public T asBlock() {
        return (T)((Block)this.block.get());
    }

    @Override
    public String getTranslationKey() {
        return this.blockItem.getTranslationKey();
    }

    public void onRegister() {
        if (this.onBlockRegistrationEvent != null) {
            this.onBlockRegistrationEvent.accept((Block)this.block.get(), (Item)this.blockItem.asItem());
        }
    }

    @Override
    public T get() {
        return this.asBlock();
    }
}

