/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines;

import aztech.modern_industrialization.blocks.TickableBlock;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineOverlay;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class MachineBlock
extends Block
implements TickableBlock {
    private final BiFunction<BlockPos, BlockState, MachineBlockEntity> blockEntityConstructor;
    private volatile MachineBlockEntity blockEntityInstance = null;

    public MachineBlock(BiFunction<BlockPos, BlockState, MachineBlockEntity> blockEntityConstructor, BlockBehaviour.Properties properties) {
        super(properties);
        this.blockEntityConstructor = blockEntityConstructor;
    }

    public MachineBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.blockEntityConstructor.apply(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        MachineBlockEntity machine;
        ItemInteractionResult beResult;
        if (world.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof MachineBlockEntity && (beResult = (machine = (MachineBlockEntity)be).useItemOn(player, hand, MachineOverlay.findHitSide(hit))).consumesAction()) {
            world.blockUpdated(pos, Blocks.AIR);
            return beResult;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof MachineBlockEntity) {
            MachineBlockEntity machine = (MachineBlockEntity)be;
            machine.openMenu((ServerPlayer)player);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity be = world.getBlockEntity(pos);
        ((MachineBlockEntity)be).onPlaced(placer, itemStack);
    }

    protected void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity be;
        if (!state.is(newState.getBlock()) && (be = world.getBlockEntity(pos)) instanceof MachineBlockEntity) {
            MachineBlockEntity machine = (MachineBlockEntity)be;
            List<ItemStack> dropExtra = machine.dropExtra();
            for (ConfigurableItemStack stack : machine.getInventory().getItemStacks()) {
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)((ItemVariant)stack.getResource()).toStack((int)stack.getAmount()));
                stack.setAmount(0L);
            }
            for (ItemStack extra : dropExtra) {
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)extra);
            }
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    public MachineBlockEntity getBlockEntityInstance() {
        if (this.blockEntityInstance == null) {
            this.blockEntityInstance = this.newBlockEntity(BlockPos.ZERO, this.defaultBlockState());
        }
        return this.blockEntityInstance;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return this.getBlockEntityInstance().hasComparatorOutput();
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MachineBlockEntity) {
            MachineBlockEntity machine = (MachineBlockEntity)blockEntity;
            return machine.getComparatorOutput();
        }
        return 0;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MachineBlockEntity) {
            MachineBlockEntity machine = (MachineBlockEntity)blockEntity;
            machine.refreshRedstoneStatus();
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MachineBlockEntity) {
            MachineBlockEntity machine = (MachineBlockEntity)blockEntity;
            machine.refreshRedstoneStatus();
        }
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter renderView, BlockPos pos, Direction side, @Nullable BlockState sourceState, @Nullable BlockPos sourcePos) {
        if (renderView instanceof ServerLevel) {
            return state;
        }
        return CommonProxy.INSTANCE.getMachineCasingBlockState(state, renderView, pos);
    }
}

