/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

abstract class PipePartBuilder {
    static final float SIDE = 0.125f;
    protected static final float SPACING = 0.0625f;
    protected static final float FIRST_POS = 0.0625f;
    Vec3 pos;
    Vec3 facing;
    Vec3 right;

    PipePartBuilder(int slotPos, Direction direction) {
        this.facing = Vec3.atLowerCornerOf((Vec3i)direction.getNormal());
        float position = 0.3125f + (float)slotPos * 0.1875f;
        this.pos = new Vec3((double)position, (double)position, (double)position);
        for (Direction d : Direction.values()) {
            this.right = Vec3.atLowerCornerOf((Vec3i)d.getNormal());
            if (this.isTowardsInside(this.right) && this.isTowardsInside(this.up())) break;
        }
        this.moveForward(0.0625f);
    }

    protected boolean isTowardsInside(Vec3 direction) {
        return (double)this.distanceToSide(direction) > 0.499999;
    }

    protected float distanceToSide(Vec3 direction) {
        float p = (float)direction.dot(this.pos);
        if (p > 0.0f) {
            return 1.0f - p;
        }
        return -p;
    }

    protected final void drawPipe(float length, Intent intent) {
        this.drawPipe(length, intent, true);
    }

    abstract void drawPipe(float var1, Intent var2, boolean var3);

    void moveForward(float amount) {
        this.pos = this.pos.add(this.facing.scale((double)amount));
    }

    Vec3 up() {
        return this.right.cross(this.facing);
    }

    protected void rotateCw() {
        this.right = this.up().scale(-1.0);
    }

    protected void turnUp() {
        this.facing = this.up();
    }

    void straightLine(boolean reduced, boolean end) {
        if (reduced) {
            this.moveForward(0.1875f);
        }
        this.drawPipe(this.distanceToSide(this.facing), Intent.STRAIGHT, end);
    }

    void shortBend(boolean reduced, boolean end) {
        if (reduced) {
            this.moveForward(0.1875f);
        }
        float dist = 0.375f;
        float advDist = this.distanceToSide(this.facing) - dist;
        boolean bendConflicting = advDist + 0.125f < 0.0f;
        this.drawPipe(advDist + 0.125f, Intent.BEND);
        this.moveForward(advDist + 0.0625f);
        this.turnUp();
        this.rotateCw();
        this.moveForward(0.0625f);
        this.drawPipe(0.1875f, bendConflicting ? Intent.BEND_CONFLICTING : Intent.BEND, !bendConflicting);
        this.moveForward(0.125f);
        this.turnUp();
        this.rotateCw();
        this.moveForward(0.0625f);
        this.drawPipe(0.1875f, Intent.BEND);
        this.moveForward(0.125f);
        this.turnUp();
        this.moveForward(0.0625f);
        this.drawPipe(this.distanceToSide(this.facing), Intent.STRAIGHT, end);
    }

    void farShortBend(boolean reduced, boolean end) {
        if (reduced) {
            this.moveForward(0.1875f);
        }
        float dist = 0.1875f;
        float advDist = this.distanceToSide(this.facing) - dist;
        this.drawPipe(advDist + 0.125f, Intent.BEND);
        this.moveForward(advDist + 0.0625f);
        this.turnUp();
        this.rotateCw();
        this.moveForward(0.0625f);
        this.drawPipe(0.1875f, Intent.BEND);
        this.moveForward(0.125f);
        this.turnUp();
        this.rotateCw();
        this.moveForward(0.0625f);
        this.drawPipe(0.1875f, Intent.BEND);
        this.moveForward(0.125f);
        this.turnUp();
        this.moveForward(0.0625f);
        this.drawPipe(this.distanceToSide(this.facing), Intent.STRAIGHT, end);
    }

    void longBend(boolean reduced, boolean end) {
        if (reduced) {
            this.moveForward(0.1875f);
        }
        float dist = 0.1875f;
        float advDist = this.distanceToSide(this.facing) - dist;
        this.drawPipe(advDist + 0.125f, Intent.BEND);
        this.moveForward(advDist + 0.0625f);
        this.turnUp();
        this.rotateCw();
        this.moveForward(0.0625f);
        this.drawPipe(0.375f, Intent.BEND);
        this.moveForward(0.3125f);
        this.turnUp();
        this.rotateCw();
        this.moveForward(0.0625f);
        this.drawPipe(0.375f, Intent.BEND);
        this.moveForward(0.3125f);
        this.turnUp();
        this.moveForward(0.0625f);
        this.drawPipe(this.distanceToSide(this.facing), Intent.STRAIGHT, end);
    }

    public static int getSlotPos(int slot) {
        return slot == 0 ? 1 : (slot == 1 ? 0 : 2);
    }

    static int getRenderType(int logicalSlot, Direction direction, PipeEndpointType[][] connections) {
        if (connections[logicalSlot][direction.get3DDataValue()] == null) {
            return 0;
        }
        if (connections[logicalSlot][direction.get3DDataValue()] != PipeEndpointType.PIPE) {
            return 1;
        }
        int connSlot = 0;
        for (int i = 0; i < logicalSlot; ++i) {
            if (connections[i][direction.get3DDataValue()] == null) continue;
            ++connSlot;
        }
        if (logicalSlot == 1) {
            if (connSlot == 0) {
                return 2;
            }
        } else if (logicalSlot == 2) {
            if (connSlot == 0) {
                return direction.getAxisDirection() == Direction.AxisDirection.NEGATIVE ? 3 : 2;
            }
            if (connSlot == 1) {
                return 4;
            }
        }
        return 1;
    }

    static Direction getInitialDirection(int logicalSlot, Direction connectionDirection, int renderType) {
        if (renderType == 2) {
            if (logicalSlot == 1) {
                if (connectionDirection == Direction.NORTH) {
                    return Direction.UP;
                }
                if (connectionDirection == Direction.WEST) {
                    return Direction.SOUTH;
                }
                if (connectionDirection == Direction.DOWN) {
                    return Direction.EAST;
                }
            } else if (logicalSlot == 2) {
                if (connectionDirection == Direction.UP) {
                    return Direction.NORTH;
                }
                if (connectionDirection == Direction.SOUTH) {
                    return Direction.WEST;
                }
                if (connectionDirection == Direction.EAST) {
                    return Direction.DOWN;
                }
            }
        }
        return connectionDirection;
    }

    public static enum Intent {
        STRAIGHT,
        BEND,
        BEND_CONFLICTING;

    }
}

