/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.tank.creativetank;

import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.blocks.storage.tank.AbstractTankBlockEntity;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class CreativeTankBlockEntity
extends AbstractTankBlockEntity {
    public CreativeTankBlockEntity(BlockPos pos, BlockState state) {
        super(MIRegistries.CREATIVE_TANK_BE.get(), pos, state);
    }

    @Override
    public boolean onPlayerUse(Player player) {
        int inserted;
        if (this.isResourceBlank()) {
            Optional fluid = FluidUtil.getFluidContained((ItemStack)player.getItemInHand(InteractionHand.MAIN_HAND));
            if (fluid.isPresent()) {
                this.setFluid(FluidVariant.of((FluidStack)fluid.get()));
                return true;
            }
            return !this.isResourceBlank();
        }
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)player.getItemInHand(InteractionHand.MAIN_HAND).getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null && (inserted = fluidHandler.fill(((FluidVariant)this.resource).toStack(Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE)) > 0) {
            player.setItemInHand(InteractionHand.MAIN_HAND, fluidHandler.getContainer());
            return true;
        }
        return false;
    }

    public void setFluid(FluidVariant variant) {
        this.resource = variant;
        this.onChanged();
    }
}

