/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.impl.emi;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerPageManager;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Nullable;

class ViewerCategoryEmi<D>
extends EmiRecipeCategory {
    public final ViewerCategory<D> wrapped;

    public ViewerCategoryEmi(final ViewerCategory<D> category) {
        EmiRenderable emiRenderable;
        ResourceLocation resourceLocation = category.id;
        ViewerCategory.Icon icon = category.icon;
        if (icon instanceof ViewerCategory.Icon.Stack) {
            ViewerCategory.Icon.Stack stack = (ViewerCategory.Icon.Stack)icon;
            emiRenderable = EmiStack.of((ItemStack)stack.stack());
        } else {
            emiRenderable = new EmiRenderable(){

                public void render(GuiGraphics guiGraphics, int x, int y, float delta) {
                    ViewerCategory.Icon.Texture texture = (ViewerCategory.Icon.Texture)category.icon;
                    guiGraphics.blit(texture.loc(), x - 1, y - 1, 0, (float)texture.u(), (float)texture.v(), 18, 18, 256, 256);
                }
            };
        }
        super(resourceLocation, emiRenderable);
        this.wrapped = category;
    }

    public Component getName() {
        return this.wrapped.title;
    }

    private void processLayout(D recipe, final List<IngredientBuilder> inputs, final List<IngredientBuilder> outputs) {
        this.wrapped.buildLayout(recipe, new ViewerCategory.LayoutBuilder(){

            @Override
            public ViewerCategory.SlotBuilder inputSlot(int x, int y) {
                IngredientBuilder ing = new IngredientBuilder(x, y);
                inputs.add(ing);
                return ing;
            }

            @Override
            public ViewerCategory.SlotBuilder outputSlot(int x, int y) {
                IngredientBuilder ing = new IngredientBuilder(x, y);
                outputs.add(ing);
                return ing;
            }

            @Override
            public void invisibleInput(ItemStack item) {
                IngredientBuilder ing = new IngredientBuilder(0, 0);
                ing.item(item);
                ing.isVisible = false;
                inputs.add(ing);
            }

            @Override
            public void invisibleOutput(ItemStack item) {
                IngredientBuilder ing = new IngredientBuilder(0, 0);
                ing.item(item);
                ing.isVisible = false;
                outputs.add(ing);
            }

            @Override
            public void scrollableSlots(int cols, int rows, List<ItemStack> stacks) {
                stacks.forEach(this::invisibleInput);
            }
        });
    }

    public void registerRecipes(EmiRegistry registry) {
        this.wrapped.buildRecipes(registry.getRecipeManager(), Minecraft.getInstance().level.registryAccess(), r -> registry.addRecipe((EmiRecipe)this.makeRecipe(r)));
    }

    private ViewerRecipe makeRecipe(D recipe) {
        ArrayList<IngredientBuilder> inputs = new ArrayList<IngredientBuilder>();
        ArrayList<IngredientBuilder> outputs = new ArrayList<IngredientBuilder>();
        this.processLayout(recipe, inputs, outputs);
        boolean excludeFromTree = outputs.stream().anyMatch(b -> !b.isVisible);
        inputs.removeIf(b -> b.ing.isEmpty());
        outputs.removeIf(b -> b.ing.isEmpty());
        List<IngredientBuilder> catalysts = inputs.stream().filter(b -> b.isCatalyst).toList();
        inputs.removeIf(b -> b.isCatalyst);
        return new ViewerRecipe(recipe, ViewerCategoryEmi.convertInputs(inputs), ViewerCategoryEmi.convertInputs(catalysts), ViewerCategoryEmi.convertOutputs(outputs), excludeFromTree);
    }

    private static List<EmiIngredient> convertInputs(List<IngredientBuilder> list) {
        return list.stream().map(b -> b.ing).toList();
    }

    private static List<EmiStack> convertOutputs(List<IngredientBuilder> list) {
        return list.stream().flatMap(b -> b.ing.getEmiStacks().stream()).toList();
    }

    private static void createFluidSlotBackground(WidgetHolder widgets, int x, int y) {
        widgets.addDrawable(0, 0, 0, 0, (guiGraphics, mouseX, mouseY, delta) -> guiGraphics.blit(MachineScreen.SLOT_ATLAS, x - 1 - 4, y - 1 - 4, 18, 0, 18, 18));
    }

    private static void processIngredient(EmiRecipe recipe, WidgetHolder widgets, IngredientBuilder ing, boolean isInput) {
        if (!ing.isVisible) {
            return;
        }
        if (ing.isFluid) {
            ViewerCategoryEmi.createFluidSlotBackground(widgets, ing.x, ing.y);
        }
        SlotWidget slot = widgets.addSlot(ing.ing, ing.x - 1 - 4, ing.y - 1 - 4);
        if (!isInput) {
            slot.recipeContext(recipe);
        }
        if (!ing.hasBackground) {
            slot.drawBack(false);
        }
        if (ing.isCatalyst) {
            slot.catalyst(true);
        }
    }

    public class ViewerRecipe
    implements EmiRecipe {
        final D recipe;
        private final List<EmiIngredient> inputs;
        private final List<EmiIngredient> catalysts;
        private final List<EmiStack> outputs;
        private final boolean excludeFromTree;

        public ViewerRecipe(D recipe, List<EmiIngredient> inputs, List<EmiIngredient> catalysts, List<EmiStack> outputs, boolean excludeFromTree) {
            this.recipe = recipe;
            this.inputs = inputs;
            this.catalysts = catalysts;
            this.outputs = outputs;
            this.excludeFromTree = excludeFromTree;
        }

        public ViewerCategoryEmi<D> getCategory() {
            return ViewerCategoryEmi.this;
        }

        public ResourceLocation getId() {
            return ViewerCategoryEmi.this.wrapped.getRecipeId(this.recipe);
        }

        public List<EmiIngredient> getInputs() {
            return this.inputs;
        }

        public List<EmiIngredient> getCatalysts() {
            return this.catalysts;
        }

        public List<EmiStack> getOutputs() {
            return this.outputs;
        }

        public int getDisplayWidth() {
            return ViewerCategoryEmi.this.wrapped.width - 8;
        }

        public int getDisplayHeight() {
            return ViewerCategoryEmi.this.wrapped.height - 8;
        }

        public void addWidgets(final WidgetHolder widgets) {
            ViewerCategoryEmi.this.wrapped.buildWidgets(this.recipe, new ViewerCategory.WidgetList(){

                @Override
                public void text(Component text, float x, float y, ViewerCategory.TextAlign align, boolean shadow, boolean overrideColor, @Nullable Component tooltip) {
                    Font font = Minecraft.getInstance().font;
                    int width = font.width((FormattedText)text);
                    int alignedX = switch (align) {
                        default -> throw new MatchException(null, null);
                        case ViewerCategory.TextAlign.LEFT -> (int)x;
                        case ViewerCategory.TextAlign.CENTER -> (int)(x - (float)width / 2.0f);
                        case ViewerCategory.TextAlign.RIGHT -> (int)(x - (float)width);
                    };
                    widgets.addText(text.getVisualOrderText(), alignedX - 4, (int)y - 4, overrideColor ? -12566464 : -1, shadow);
                    if (tooltip != null) {
                        int n = (int)y;
                        Objects.requireNonNull(font);
                        this.tooltip(alignedX, n, width, 9, List.of(tooltip));
                    }
                }

                @Override
                public void arrow(int x, int y) {
                    this.texture(MI.id("textures/gui/jei/arrow.png"), x, y, 0, 17, 24, 17);
                }

                @Override
                public void texture(ResourceLocation loc, int x, int y, int u, int v, int width, int height) {
                    widgets.addTexture(loc, x - 4, y - 4, width, height, u, v);
                }

                @Override
                public void drawable(Consumer<GuiGraphics> widget) {
                    widgets.addDrawable(-4, -4, 0, 0, (matrices, mouseX, mouseY, delta) -> widget.accept(matrices));
                }

                @Override
                public void tooltip(int x, int y, int w, int h, List<Component> tooltip) {
                    List<ClientTooltipComponent> mapped = tooltip.stream().map(c -> ClientTooltipComponent.create((FormattedCharSequence)c.getVisualOrderText())).toList();
                    widgets.addDrawable(x - 4, y - 4, w, h, (matrices, mouseX, mouseY, delta) -> {}).tooltip((mouseX, mouseY) -> mapped);
                }

                @Override
                public void scrollableSlots(int cols, int rows, List<ItemStack> stacks) {
                    int index;
                    int offsetX = widgets.getWidth() / 2 - cols * 18 / 2;
                    int offsetY = 20;
                    int pageHeight = (widgets.getHeight() - 21) / 18;
                    int pageSize = cols * rows;
                    final ViewerPageManager pages = new ViewerPageManager(stacks, pageSize);
                    if (pageSize < stacks.size()) {
                        widgets.addButton(2, 2, 12, 12, 0, 0, () -> true, (mx, my, button) -> pages.scroll(-1));
                        widgets.addButton(widgets.getWidth() - 14, 2, 12, 12, 12, 0, () -> true, (mx, my, button) -> pages.scroll(1));
                    }
                    for (index = 0; index < stacks.size() && index / cols <= pageHeight; ++index) {
                        final int finalIndex = index;
                        widgets.add((Widget)new SlotWidget(this, (EmiIngredient)EmiStack.EMPTY, index % cols * 18 + offsetX, index / cols * 18 + offsetY){

                            public EmiIngredient getStack() {
                                return EmiStack.of((ItemStack)pages.getStack(finalIndex));
                            }

                            public void drawStack(GuiGraphics draw, int mouseX, int mouseY, float delta) {
                                ItemStack stack = pages.getStack(finalIndex);
                                Bounds bounds = this.getBounds();
                                int xOff = (bounds.width() - 16) / 2;
                                int yOff = (bounds.height() - 16) / 2;
                                int stackX = bounds.x() + xOff;
                                int stackY = bounds.y() + yOff;
                                EmiStack.of((ItemStack)stack, (long)1L).render(draw, stackX, stackY, delta);
                                MutableComponent amount = Component.literal((String)String.valueOf(stack.getCount()));
                                float scale = 0.8f;
                                draw.pose().pushPose();
                                draw.pose().translate(0.0f, 0.0f, 200.0f);
                                int tx = stackX + 17 - Math.min(14, Math.round((float)Minecraft.getInstance().font.width((FormattedText)amount) * scale)) - 1;
                                draw.pose().translate((float)tx, (float)(stackY + 9), 0.0f);
                                draw.pose().scale(scale, scale, 1.0f);
                                draw.drawString(Minecraft.getInstance().font, (Component)amount, 0, 0, -1, true);
                                draw.pose().popPose();
                            }
                        });
                    }
                    while (index < pageSize) {
                        widgets.addSlot((EmiIngredient)EmiStack.EMPTY, index % cols * 18 + offsetX, index / cols * 18 + offsetY);
                        ++index;
                    }
                }
            });
            ArrayList<IngredientBuilder> inputs = new ArrayList<IngredientBuilder>();
            ArrayList<IngredientBuilder> outputs = new ArrayList<IngredientBuilder>();
            ViewerCategoryEmi.this.processLayout(this.recipe, inputs, outputs);
            for (IngredientBuilder input : inputs) {
                ViewerCategoryEmi.processIngredient(this, widgets, input, true);
            }
            for (IngredientBuilder output : outputs) {
                ViewerCategoryEmi.processIngredient(this, widgets, output, false);
            }
        }

        public boolean supportsRecipeTree() {
            return !this.excludeFromTree && super.supportsRecipeTree();
        }
    }

    private static class IngredientBuilder
    implements ViewerCategory.SlotBuilder {
        private final int x;
        private final int y;
        private EmiIngredient ing = EmiStack.EMPTY;
        private boolean isFluid = false;
        private boolean hasBackground = true;
        private boolean isVisible = true;
        private boolean isCatalyst = false;

        IngredientBuilder(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public ViewerCategory.SlotBuilder variant(TransferVariant<?> variant) {
            if (variant instanceof ItemVariant) {
                ItemVariant item = (ItemVariant)variant;
                this.item(item.toStack());
            } else if (variant instanceof FluidVariant) {
                FluidVariant fluid = (FluidVariant)variant;
                this.isFluid = true;
                this.hasBackground = false;
                if (!fluid.isBlank()) {
                    this.ing = EmiStack.of((Fluid)fluid.getFluid(), (DataComponentPatch)fluid.getComponentsPatch());
                }
            } else {
                throw new IllegalArgumentException("Unknown variant type: " + String.valueOf(variant.getClass()));
            }
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder fluid(FluidVariant fluid, long amount, float probability) {
            this.isFluid = true;
            this.hasBackground = false;
            this.ing = EmiStack.of((Fluid)fluid.getFluid(), (DataComponentPatch)fluid.getComponentsPatch(), (long)amount);
            this.processProbability(probability);
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder fluid(FluidIngredient ingredient, long amount, float probability) {
            this.isFluid = true;
            this.hasBackground = false;
            this.ing = EmiIngredient.of(Stream.of(ingredient.getStacks()).map(fs -> EmiStack.of((Fluid)fs.getFluid(), (DataComponentPatch)fs.getComponentsPatch())).toList(), (long)amount);
            this.processProbability(probability);
            return this;
        }

        private void processProbability(float probability) {
            if (probability == 0.0f) {
                this.markCatalyst();
            } else {
                this.ing.setChance(probability);
            }
        }

        @Override
        public ViewerCategory.SlotBuilder item(ItemStack stack, float probability) {
            this.ing = EmiStack.of((ItemStack)stack);
            this.processProbability(probability);
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder ingredient(Ingredient ingredient, long amount, float probability) {
            this.ing = EmiIngredient.of((Ingredient)ingredient, (long)amount);
            this.processProbability(probability);
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder removeBackground() {
            this.hasBackground = false;
            return this;
        }

        @Override
        public ViewerCategory.SlotBuilder markCatalyst() {
            this.isCatalyst = true;
            return this;
        }
    }
}

