/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen;

import aztech.modern_industrialization.datagen.AggregateDataProvider;
import aztech.modern_industrialization.datagen.advancement.MIAdvancementsProvider;
import aztech.modern_industrialization.datagen.datamap.MIDataMapProvider;
import aztech.modern_industrialization.datagen.dynreg.DynamicRegistryDatagen;
import aztech.modern_industrialization.datagen.loot.BlockLootTableProvider;
import aztech.modern_industrialization.datagen.loot.MIGiftLoot;
import aztech.modern_industrialization.datagen.recipe.AlloyRecipesProvider;
import aztech.modern_industrialization.datagen.recipe.AssemblerRecipesProvider;
import aztech.modern_industrialization.datagen.recipe.CompatRecipesProvider;
import aztech.modern_industrialization.datagen.recipe.DyeRecipesProvider;
import aztech.modern_industrialization.datagen.recipe.HatchRecipesProvider;
import aztech.modern_industrialization.datagen.recipe.HeatExchangerRecipesProvider;
import aztech.modern_industrialization.datagen.recipe.MaterialRecipesProvider;
import aztech.modern_industrialization.datagen.recipe.PetrochemRecipesProvider;
import aztech.modern_industrialization.datagen.recipe.PlankRecipesProvider;
import aztech.modern_industrialization.datagen.recipe.UpgradeProvider;
import aztech.modern_industrialization.datagen.recipe.VanillaCompatRecipesProvider;
import aztech.modern_industrialization.datagen.structure.EmptyTestStructureGenerator;
import aztech.modern_industrialization.datagen.tag.MIBlockTagProvider;
import aztech.modern_industrialization.datagen.tag.MIFluidTagProvider;
import aztech.modern_industrialization.datagen.tag.MIItemTagProvider;
import aztech.modern_industrialization.datagen.tag.MIPoiTypeTagProvider;
import aztech.modern_industrialization.datagen.translation.TranslationProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class MIDatagenServer {
    public static void configure(DataGenerator gen, ExistingFileHelper fileHelper, CompletableFuture<HolderLookup.Provider> lookupProvider, boolean run, boolean runtimeDatagen) {
        AggregateDataProvider aggregate = (AggregateDataProvider)gen.addProvider(run, (DataProvider)new AggregateDataProvider(gen.getPackOutput(), "Server Data"));
        aggregate.addProvider(PetrochemRecipesProvider::new);
        aggregate.addProvider(PlankRecipesProvider::new);
        aggregate.addProvider(HeatExchangerRecipesProvider::new);
        aggregate.addProvider(HatchRecipesProvider::new);
        aggregate.addProvider(AlloyRecipesProvider::new);
        aggregate.addProvider(MaterialRecipesProvider::new);
        aggregate.addProvider(DyeRecipesProvider::new);
        aggregate.addProvider(AssemblerRecipesProvider::new);
        if (!runtimeDatagen) {
            aggregate.addProvider(CompatRecipesProvider::new);
        }
        aggregate.addProvider(UpgradeProvider::new);
        aggregate.addProvider(VanillaCompatRecipesProvider::new);
        aggregate.addProvider(EmptyTestStructureGenerator::new);
        gen.addProvider(run, (DataProvider)new LootTableProvider(gen.getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTableProvider::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(MIGiftLoot::new, LootContextParamSets.GIFT)), lookupProvider));
        gen.addProvider(run, (DataProvider)new DatapackBuiltinEntriesProvider(gen.getPackOutput(), lookupProvider, DynamicRegistryDatagen.getBuilder(), Set.of("modern_industrialization")));
        gen.addProvider(run, (DataProvider)new MIBlockTagProvider(gen.getPackOutput(), lookupProvider, fileHelper));
        gen.addProvider(run, (DataProvider)new MIFluidTagProvider(gen.getPackOutput(), lookupProvider, fileHelper));
        gen.addProvider(run, (DataProvider)new MIItemTagProvider(gen.getPackOutput(), lookupProvider, fileHelper, runtimeDatagen));
        gen.addProvider(run, (DataProvider)new MIPoiTypeTagProvider(gen.getPackOutput(), lookupProvider, fileHelper));
        gen.addProvider(run, (DataProvider)new MIDataMapProvider(gen.getPackOutput(), lookupProvider));
        TranslationProvider translationProvider = new TranslationProvider(gen.getPackOutput());
        gen.addProvider(run, (DataProvider)new AdvancementProvider(gen.getPackOutput(), lookupProvider, fileHelper, List.of(new MIAdvancementsProvider(translationProvider))));
        gen.addProvider(run, (DataProvider)translationProvider);
    }
}

