/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.hatches;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.NeutronHistoryComponent;
import aztech.modern_industrialization.machines.components.NuclearEfficiencyHistoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.SteamHeaterComponent;
import aztech.modern_industrialization.machines.components.TemperatureComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.TemperatureBar;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.HatchTypes;
import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.nuclear.INuclearTile;
import aztech.modern_industrialization.nuclear.NeutronType;
import aztech.modern_industrialization.nuclear.NuclearAbsorbable;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import com.google.common.base.Preconditions;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.jetbrains.annotations.Nullable;

public class NuclearHatch
extends HatchBlockEntity
implements INuclearTile {
    private final MIInventory inventory;
    public final NeutronHistoryComponent neutronHistory;
    public final TemperatureComponent nuclearReactorComponent;
    public final boolean isFluid;
    public static final long capacity = 64000L;

    public NuclearHatch(BEP bep, boolean isFluid) {
        super(bep, new MachineGuiParameters.Builder(isFluid ? "nuclear_fluid_hatch" : "nuclear_item_hatch", true).build(), new OrientationComponent.Params(false, false, false));
        this.isFluid = isFluid;
        SlotPositions slotPos = new SlotPositions.Builder().addSlot(68, 31).addSlots(98, 22, 1, 2).build();
        if (!isFluid) {
            ArrayList<ConfigurableItemStack> itemStack = new ArrayList<ConfigurableItemStack>();
            itemStack.add(ConfigurableItemStack.standardInputSlot());
            itemStack.add(ConfigurableItemStack.standardOutputSlot());
            itemStack.add(ConfigurableItemStack.standardOutputSlot());
            this.inventory = new MIInventory(itemStack, Collections.emptyList(), slotPos, SlotPositions.empty());
            this.nuclearReactorComponent = new TemperatureComponent(3250.0);
        } else {
            ArrayList<ConfigurableFluidStack> fluidStack = new ArrayList<ConfigurableFluidStack>();
            fluidStack.add(ConfigurableFluidStack.standardInputSlot(64000L));
            fluidStack.add(ConfigurableFluidStack.standardOutputSlot(64000L));
            fluidStack.add(ConfigurableFluidStack.standardOutputSlot(64000L));
            this.inventory = new MIInventory(Collections.emptyList(), fluidStack, SlotPositions.empty(), slotPos);
            this.nuclearReactorComponent = new SteamHeaterComponent(3250.0, 8192L, 64L, true, true, false);
        }
        this.neutronHistory = new NeutronHistoryComponent();
        this.registerComponents(this.inventory, this.nuclearReactorComponent, this.neutronHistory);
        TemperatureBar.Parameters temperatureParams = new TemperatureBar.Parameters(43, 63, 3250);
        this.registerGuiComponent(new TemperatureBar.Server(temperatureParams, () -> (int)this.nuclearReactorComponent.getTemperature()));
    }

    @Override
    public HatchType getHatchType() {
        return this.isFluid ? HatchTypes.NUCLEAR_FLUID : HatchTypes.NUCLEAR_ITEM;
    }

    @Override
    public boolean upgradesToSteel() {
        return false;
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    public final void tick() {
        super.tick();
        this.clearMachineLock();
        if (this.isFluid) {
            this.fluidNeutronProductTick(1, true);
        } else {
            NuclearAbsorbable abs;
            Item item;
            ItemVariant itemVariant = (ItemVariant)this.getVariant();
            if (!itemVariant.isBlank() && (item = itemVariant.getItem()) instanceof NuclearAbsorbable && (abs = (NuclearAbsorbable)item).getNeutronProduct() != null) {
                try (Transaction tx = Transaction.openRoot();){
                    this.inventory.itemStorage.insert((ItemVariant)abs.getNeutronProduct(), abs.getNeutronProductAmount(), tx, AbstractConfigurableStack::canPipesExtract, true);
                }
            }
        }
    }

    @Override
    public double getTemperature() {
        return this.nuclearReactorComponent.getTemperature();
    }

    @Override
    public double getHeatTransferCoeff() {
        @Nullable INuclearComponent component = this.getComponent();
        return Math.max(0.01 + (component != null ? component.getHeatConduction() : 0.0), 0.0);
    }

    @Override
    public double getMeanNeutronAbsorption(NeutronType type) {
        return this.neutronHistory.getAverageReceived(type);
    }

    @Override
    public double getMeanNeutronFlux(NeutronType type) {
        return this.neutronHistory.getAverageFlux(type);
    }

    @Override
    public double getMeanNeutronGeneration() {
        return this.neutronHistory.getAverageGeneration();
    }

    @Override
    public double getMeanEuGeneration() {
        return this.neutronHistory.getAverageEuGeneration();
    }

    @Override
    public TransferVariant getVariant() {
        if (this.isFluid) {
            return this.inventory.getFluidStacks().get(0).getResource();
        }
        return this.inventory.getItemStacks().get(0).getResource();
    }

    @Override
    public long getVariantAmount() {
        if (this.isFluid) {
            return this.inventory.getFluidStacks().get(0).getAmount();
        }
        return this.inventory.getItemStacks().get(0).getAmount();
    }

    @Override
    public boolean isFluid() {
        return this.isFluid;
    }

    @Override
    public void setTemperature(double temp) {
        this.nuclearReactorComponent.setTemperature(temp);
    }

    @Override
    public void putHeat(double eu) {
        Preconditions.checkArgument((eu >= 0.0 ? 1 : 0) != 0);
        this.setTemperature(this.getTemperature() + eu / 64.0);
        this.neutronHistory.addValue(NeutronHistoryComponent.Type.euGeneration, (int)eu);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int neutronGenerationTick(NuclearEfficiencyHistoryComponent efficiencyHistory) {
        meanNeutron = this.getMeanNeutronAbsorption(NeutronType.BOTH);
        neutronsProduced = 0;
        if (!this.isFluid) {
            itemVariant = (ItemVariant)this.getVariant();
            if (!itemVariant.isBlank() && (var7_5 = itemVariant.getItem()) instanceof NuclearAbsorbable) {
                abs = (NuclearAbsorbable)var7_5;
                if (itemVariant.getItem() instanceof NuclearFuel) {
                    meanNeutron += 0.1;
                }
                stack = itemVariant.toStack((int)this.getVariantAmount());
                rand = this.level.getRandom();
                if (abs instanceof NuclearFuel) {
                    fuel = (NuclearFuel)abs;
                    neutronsProduced = fuel.simulateDesintegration(meanNeutron, stack, this.nuclearReactorComponent.getTemperature(), rand, efficiencyHistory);
                } else {
                    abs.simulateAbsorption(meanNeutron, stack, rand);
                }
                if (abs.getRemainingDesintegrations(stack) == 0) {
                    tx = Transaction.openRoot();
                    try {
                        absStack = this.inventory.getItemStacks().get(0);
                        absStack.updateSnapshots(tx);
                        absStack.setAmount(0L);
                        absStack.setKey(ItemVariant.blank());
                        if (abs.getNeutronProduct() != null) {
                            inserted = this.inventory.itemStorage.insert((ItemVariant)abs.getNeutronProduct(), abs.getNeutronProductAmount(), tx, (Predicate<ConfigurableItemStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, canPipesExtract(), (Laztech/modern_industrialization/inventory/ConfigurableItemStack;)Z)(), true);
                            if (inserted != abs.getNeutronProductAmount()) ** GOTO lbl36
                            tx.commit();
                        }
                        tx.commit();
                    }
                    finally {
                        if (tx != null) {
                            tx.close();
                        }
                    }
                } else {
                    this.getInventory().getItemStacks().get(0).setKey(ItemVariant.of(stack));
                }
            }
lbl36:
            // 6 sources

            this.neutronHistory.addValue(NeutronHistoryComponent.Type.neutronGeneration, neutronsProduced);
            return neutronsProduced;
        }
        return 0;
    }

    private static int randIntFromDouble(double value, RandomSource rand) {
        return (int)Math.floor(value) + (rand.nextDouble() < value % 1.0 ? 1 : 0);
    }

    public void fluidNeutronProductTick(int neutron, boolean simul) {
        if (this.isFluid) {
            @Nullable INuclearComponent component = this.getComponent();
            if (component == null) {
                return;
            }
            double fluidConsumption = (double)neutron * component.getNeutronProductProbability() * 1.0 / 81.0;
            int actualRecipe = NuclearHatch.randIntFromDouble(fluidConsumption, this.getLevel().getRandom());
            if (simul) {
                actualRecipe = neutron;
            }
            if (simul || actualRecipe > 0) {
                try (Transaction tx = Transaction.openRoot();){
                    long extracted = this.inventory.fluidStorage.extractAllSlot((FluidVariant)component.getVariant(), actualRecipe, tx, AbstractConfigurableStack::canPipesInsert);
                    this.inventory.fluidStorage.insert((FluidVariant)component.getNeutronProduct(), extracted * component.getNeutronProductAmount(), tx, AbstractConfigurableStack::canPipesExtract, true);
                    if (!simul) {
                        tx.commit();
                    }
                }
            }
        }
    }

    private void checkComponentMaxTemperature() {
        INuclearComponent component;
        if (!this.isFluid && (component = this.getComponent()) != null && (double)component.getMaxTemperature() < this.getTemperature()) {
            this.inventory.getItemStacks().get(0).empty();
        }
    }

    @Override
    public void nuclearTick(NuclearEfficiencyHistoryComponent efficiencyHistory) {
        this.neutronHistory.tick();
        this.fluidNeutronProductTick(NuclearHatch.randIntFromDouble(this.neutronHistory.getAverageReceived(NeutronType.BOTH), this.getLevel().getRandom()), false);
        if (this.isFluid) {
            double euProduced = ((SteamHeaterComponent)this.nuclearReactorComponent).tick(Collections.singletonList(this.inventory.getFluidStacks().get(0)), this.inventory.getFluidStacks().stream().filter(AbstractConfigurableStack::canPipesExtract).collect(Collectors.toList()));
            efficiencyHistory.registerEuProduction(euProduced);
        }
        this.checkComponentMaxTemperature();
    }

    @Override
    public void absorbNeutrons(int neutronNumber, NeutronType type) {
        Preconditions.checkArgument((type != NeutronType.BOTH ? 1 : 0) != 0);
        if (type == NeutronType.FAST) {
            this.neutronHistory.addValue(NeutronHistoryComponent.Type.fastNeutronReceived, neutronNumber);
        } else {
            this.neutronHistory.addValue(NeutronHistoryComponent.Type.thermalNeutronReceived, neutronNumber);
        }
    }

    @Override
    public void addNeutronsToFlux(int neutronNumber, NeutronType type) {
        Preconditions.checkArgument((type != NeutronType.BOTH ? 1 : 0) != 0);
        if (type == NeutronType.FAST) {
            this.neutronHistory.addValue(NeutronHistoryComponent.Type.fastNeutronFlux, neutronNumber);
        } else {
            this.neutronHistory.addValue(NeutronHistoryComponent.Type.thermalNeutronFlux, neutronNumber);
        }
    }

    public static void registerItemApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, bet, (be, direction) -> direction == Direction.UP ? ((NuclearHatch)be).getInventory().itemStorage.itemHandler : null));
    }

    public static void registerFluidApi(BlockEntityType<?> bet) {
        MICapabilities.onEvent(event -> event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, bet, (be, direction) -> direction == Direction.UP ? ((NuclearHatch)be).getInventory().fluidStorage.fluidHandler : null));
    }

    @Override
    public List<Component> getTooltips() {
        if (this.isFluid) {
            return List.of(new MITooltips.Line(MIText.MaxEuProductionSteam).arg(8192, MITooltips.EU_PER_TICK_PARSER).arg(MIFluids.STEAM).build(), new MITooltips.Line(MIText.AcceptLowAndHighPressure).arg(Fluids.WATER).arg(MIFluids.HEAVY_WATER).arg(MIFluids.HIGH_PRESSURE_WATER).arg(MIFluids.HIGH_PRESSURE_HEAVY_WATER).build());
        }
        return Collections.emptyList();
    }
}

