/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.Nullable;

public class ShapeTemplate {
    public final Map<BlockPos, SimpleMember> simpleMembers = new HashMap<BlockPos, SimpleMember>();
    public final Map<BlockPos, HatchFlags> hatchFlags = new HashMap<BlockPos, HatchFlags>();
    public final MachineCasing hatchCasing;

    private ShapeTemplate(MachineCasing hatchCasing) {
        this.hatchCasing = hatchCasing;
    }

    public static class LayeredBuilder {
        private final Builder innerBuilder;
        private final String[][] layers;
        private final Set<Character> missingKeys = new HashSet<Character>();
        private final Map<Character, KeyDefinition> keyDefinitions = new HashMap<Character, KeyDefinition>();
        private int iController;
        private int jController;
        private int kController;

        public LayeredBuilder(MachineCasing hatchCasing, String[][] layers) {
            this.innerBuilder = new Builder(hatchCasing);
            if (layers.length == 0) {
                throw new IllegalArgumentException("No layers provided");
            }
            if (layers[0].length == 0) {
                throw new IllegalArgumentException("Layer 0 cannot have size 0");
            }
            if (layers[0][0].length() == 0) {
                throw new IllegalArgumentException("Layer 0 cannot have size 0");
            }
            int dim1 = layers.length;
            int dim2 = layers[0].length;
            int dim3 = layers[0][0].length();
            boolean foundController = false;
            for (int i = 0; i < dim1; ++i) {
                if (layers[i].length != dim2) {
                    throw new IllegalArgumentException("Layer %d has invalid size, expected %d".formatted(i, dim2));
                }
                for (int j = 0; j < dim2; ++j) {
                    if (layers[i][j].length() != dim3) {
                        throw new IllegalArgumentException("Layer %d entry %d has invalid size, expected %d".formatted(i, j, dim3));
                    }
                    for (int k = 0; k < dim3; ++k) {
                        char c = layers[i][j].charAt(k);
                        if (c == '#') {
                            if (foundController) {
                                throw new IllegalArgumentException("Multiple controllers found (character #)");
                            }
                            foundController = true;
                            this.iController = i;
                            this.jController = j;
                            this.kController = k;
                            continue;
                        }
                        if (c == ' ') continue;
                        this.missingKeys.add(Character.valueOf(c));
                    }
                }
            }
            this.layers = layers;
        }

        public LayeredBuilder key(char key, SimpleMember member, @Nullable HatchFlags flags) {
            if (this.keyDefinitions.containsKey(Character.valueOf(key))) {
                throw new IllegalArgumentException("Key '%c' was already defined".formatted(Character.valueOf(key)));
            }
            if (!this.missingKeys.contains(Character.valueOf(key))) {
                throw new IllegalArgumentException("Key '%c' it not part of the shape layers".formatted(Character.valueOf(key)));
            }
            this.missingKeys.remove(Character.valueOf(key));
            this.keyDefinitions.put(Character.valueOf(key), new KeyDefinition(member, flags));
            return this;
        }

        public ShapeTemplate build() {
            if (!this.missingKeys.isEmpty()) {
                throw new IllegalArgumentException("Missing keys: " + String.valueOf(this.missingKeys));
            }
            for (int i = 0; i < this.layers.length; ++i) {
                for (int j = 0; j < this.layers[i].length; ++j) {
                    for (int k = 0; k < this.layers[i][j].length(); ++k) {
                        char c = this.layers[i][j].charAt(k);
                        if (c == ' ' || c == '#') continue;
                        KeyDefinition def = this.keyDefinitions.get(Character.valueOf(c));
                        int iAdjusted = i - this.iController;
                        int jAdjusted = j - this.jController;
                        int kAdjusted = k - this.kController;
                        this.innerBuilder.add(kAdjusted, jAdjusted, -iAdjusted, def.member, def.flags);
                    }
                }
            }
            return this.innerBuilder.build();
        }

        private record KeyDefinition(SimpleMember member, @Nullable HatchFlags flags) {
        }
    }

    public static class Builder {
        private final ShapeTemplate template;

        public Builder(MachineCasing hatchCasing) {
            this.template = new ShapeTemplate(hatchCasing);
        }

        public Builder add3by3Levels(int minY, int maxY, SimpleMember member, @Nullable HatchFlags flags) {
            for (int y = minY; y <= maxY; ++y) {
                this.add3by3(y, member, y != minY, y == minY || y == maxY ? flags : null);
            }
            return this;
        }

        public Builder add3by3LevelsRoofed(int minY, int maxY, SimpleMember member, @Nullable HatchFlags flags) {
            for (int y = minY; y <= maxY; ++y) {
                this.add3by3(y, member, y != minY && y != maxY, y == minY || y == maxY ? flags : null);
            }
            return this;
        }

        public Builder add(int x, int y, int z, SimpleMember member, @Nullable HatchFlags flags) {
            BlockPos pos = new BlockPos(x, y, z);
            this.template.simpleMembers.put(pos, member);
            if (flags != null) {
                this.template.hatchFlags.put(pos, flags);
            }
            return this;
        }

        public Builder add(int x, int y, int z, SimpleMember member) {
            return this.add(x, y, z, member, null);
        }

        public Builder add3by3(int y, SimpleMember member, boolean hollow, @Nullable HatchFlags flags) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = 0; z <= 2; ++z) {
                    if (hollow && x == 0 && z == 1) continue;
                    this.add(x, y, z, member, flags);
                }
            }
            return this;
        }

        public Builder remove(int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            this.template.simpleMembers.remove(pos);
            this.template.hatchFlags.remove(pos);
            return this;
        }

        public ShapeTemplate build() {
            this.remove(0, 0, 0);
            return this.template;
        }
    }
}

