/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe.condition;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.proxy.CommonProxy;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public record BiomeProcessCondition(Either<ResourceKey<Biome>, TagKey<Biome>> biome) implements MachineProcessCondition
{
    static final MapCodec<BiomeProcessCondition> CODEC = NeoForgeExtraCodecs.xor((MapCodec)ResourceKey.codec((ResourceKey)Registries.BIOME).fieldOf("biome"), (MapCodec)TagKey.codec((ResourceKey)Registries.BIOME).fieldOf("tag")).xmap(BiomeProcessCondition::new, BiomeProcessCondition::biome);
    static final StreamCodec<RegistryFriendlyByteBuf, BiomeProcessCondition> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.either((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.BIOME), (StreamCodec)ResourceLocation.STREAM_CODEC.map(rl -> TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rl), TagKey::location)), BiomeProcessCondition::biome, BiomeProcessCondition::new);

    @Override
    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        Holder entityBiome = context.getLevel().getBiome(context.getBlockEntity().getBlockPos());
        return (Boolean)this.biome.map(arg_0 -> ((Holder)entityBiome).is(arg_0), arg_0 -> ((Holder)entityBiome).is(arg_0));
    }

    private static MutableComponent biomeId(ResourceLocation biomeLocation) {
        return Component.translatable((String)Util.makeDescriptionId((String)"biome", (ResourceLocation)biomeLocation));
    }

    @Override
    public void appendDescription(List<Component> list) {
        this.biome.ifLeft(rk -> list.add((Component)MIText.RequiresBiome.text(BiomeProcessCondition.biomeId(rk.location())))).ifRight(tag -> {
            RegistryAccess holderLookup = CommonProxy.INSTANCE.getClientPlayer().registryAccess();
            MutableComponent biomeNames = holderLookup.lookupOrThrow(tag.registry()).get(tag).map(named -> named.stream().map(holder -> BiomeProcessCondition.biomeId(((ResourceKey)holder.unwrapKey().orElseThrow()).location())).reduce((a, b) -> a.append(", ").append((Component)b)).orElseThrow()).orElse(Component.literal((String)"???"));
            list.add((Component)MIText.RequiresBiome.text(biomeNames));
        });
    }

    @Override
    public ItemStack icon() {
        return Items.OAK_SAPLING.getDefaultInstance();
    }

    @Override
    public MapCodec<? extends MachineProcessCondition> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition> streamCodec() {
        return STREAM_CODEC;
    }
}

