/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.api.PipeRenderer;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import aztech.modern_industrialization.pipes.impl.PipeRenderContext;
import aztech.modern_industrialization.thirdparty.fabricrendering.ModelHelper;
import aztech.modern_industrialization.thirdparty.fabricrendering.SpriteFinder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PipeBakedModel
implements IDynamicBakedModel {
    private static final ChunkRenderTypeSet RENDER_TYPES_NORMAL = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutout(), RenderType.translucent()});
    private final TextureAtlasSprite particleSprite;
    private final Map<PipeRenderer.Factory, PipeRenderer> renderers;
    private final BakedModel[] meWireConnectors;
    private final SpriteFinder spriteFinder;
    private static final int QUAD_STRIDE = DefaultVertexFormat.BLOCK.getVertexSize() / 4;
    private static final int VERTEX_COLOR = 3;
    private static final PipeRenderContext.QuadTransform ITEM_TRANSFORM = quad -> {
        for (int i = 0; i < 4; ++i) {
            Vector3f pos = quad.copyPos(i, null);
            quad.pos(i, pos.x(), pos.y() * 2.0f - 0.5f, pos.z() * 2.0f - 0.5f);
        }
        return quad.tag() != 1;
    };

    public PipeBakedModel(TextureAtlasSprite particleSprite, Map<PipeRenderer.Factory, PipeRenderer> renderers, @Nullable BakedModel[] meWireConnectors, SpriteFinder spriteFinder) {
        this.particleSprite = particleSprite;
        this.renderers = renderers;
        this.meWireConnectors = meWireConnectors;
        this.spriteFinder = spriteFinder;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        return modelData.derive().with(ExtraData.KEY, (Object)new ExtraData(level, pos)).build();
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        PipeBlockEntity.RenderAttachment attachment = (PipeBlockEntity.RenderAttachment)data.get(PipeBlockEntity.RenderAttachment.KEY);
        if (attachment == null || attachment.camouflage() == null) {
            return RENDER_TYPES_NORMAL;
        }
        return ChunkRenderTypeSet.all();
    }

    private static boolean checkRenderType(RenderType target, @Nullable RenderType type) {
        return type == target || type == null;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
        boolean processCamouflage;
        List<BakedQuad> ret = null;
        PipeBlockEntity.RenderAttachment attachment = (PipeBlockEntity.RenderAttachment)data.get(PipeBlockEntity.RenderAttachment.KEY);
        ExtraData extraData = (ExtraData)data.get(ExtraData.KEY);
        if (attachment == null || extraData == null) {
            return List.of();
        }
        BlockState camouflage = attachment.camouflage();
        if (camouflage == null || MIPipes.transparentCamouflage) {
            boolean renderNormal = PipeBakedModel.checkRenderType(RenderType.cutout(), renderType);
            boolean renderFluid = PipeBakedModel.checkRenderType(RenderType.translucent(), renderType);
            if (renderNormal || renderFluid) {
                PipeRenderContext renderContext = new PipeRenderContext(this.spriteFinder, renderNormal, renderFluid);
                ret = renderContext.quads;
                int centerSlots = attachment.types().length;
                for (int slot = 0; slot < centerSlots; ++slot) {
                    int color = attachment.types()[slot].getColor();
                    renderContext.pushTransform(PipeBakedModel.getColorTransform(color));
                    this.renderers.get(PipeRenderer.get(attachment.types()[slot])).draw(extraData.level(), extraData.pos(), renderContext, slot, attachment.renderedConnections(), attachment.customData()[slot]);
                    renderContext.popTransform();
                }
            }
            if (renderNormal) {
                boolean hasMeWire = false;
                if (this.meWireConnectors != null) {
                    for (PipeNetworkType type : attachment.types()) {
                        if (!type.getIdentifier().getPath().endsWith("me_wire")) continue;
                        hasMeWire = true;
                    }
                }
                if (hasMeWire) {
                    for (Direction direction : Direction.values()) {
                        boolean renderConnector = false;
                        for (int slot = 0; slot < attachment.types().length; ++slot) {
                            PipeEndpointType conn = attachment.renderedConnections()[slot][direction.get3DDataValue()];
                            if (conn != PipeEndpointType.BLOCK || !attachment.types()[slot].getIdentifier().getPath().endsWith("me_wire")) continue;
                            renderConnector = true;
                        }
                        if (!renderConnector) continue;
                        ret.addAll(this.meWireConnectors[direction.get3DDataValue()].getQuads(state, side, rand, data, renderType));
                    }
                }
            }
        }
        boolean bl = processCamouflage = !MIPipes.transparentCamouflage || PipeBakedModel.checkRenderType(RenderType.translucent(), renderType);
        if (camouflage != null && processCamouflage) {
            PipeBlockEntity.RenderAttachment adjacentModelData;
            if (MIPipes.transparentCamouflage && side != null && (adjacentModelData = (PipeBlockEntity.RenderAttachment)extraData.level().getModelData(extraData.pos().relative(side)).get(PipeBlockEntity.RenderAttachment.KEY)) != null && adjacentModelData.camouflage() != null) {
                return ret != null ? ret : List.of();
            }
            BakedModel camouflageModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(camouflage);
            ModelData camouflageModelData = camouflageModel.getModelData(extraData.level(), extraData.pos(), camouflage, ModelData.EMPTY);
            for (BakedQuad quad : camouflageModel.getQuads(camouflage, side, rand, camouflageModelData, renderType)) {
                if (quad.isTinted() || MIPipes.transparentCamouflage) {
                    int[] quadData = (int[])quad.getVertices().clone();
                    if (quad.isTinted()) {
                        BlockColors blockColorMap = Minecraft.getInstance().getBlockColors();
                        int color = 0xFF000000 | blockColorMap.getColor(camouflage, extraData.level(), extraData.pos(), quad.getTintIndex());
                        for (int vertex = 0; vertex < 4; ++vertex) {
                            PipeBakedModel.setColor(quadData, vertex, PipeBakedModel.multiplyColor(color, PipeBakedModel.getColor(quadData, vertex)));
                        }
                    }
                    if (MIPipes.transparentCamouflage) {
                        for (int vertex = 0; vertex < 4; ++vertex) {
                            PipeBakedModel.setColor(quadData, vertex, PipeBakedModel.multiplyColor(-1610612737, PipeBakedModel.getColor(quadData, vertex)));
                        }
                    }
                    quad = new BakedQuad(quadData, -1, quad.getDirection(), quad.getSprite(), quad.isShade(), quad.hasAmbientOcclusion());
                }
                if (ret == null) {
                    ret = new ArrayList<BakedQuad>();
                }
                ret.add(quad);
            }
        }
        return ret != null ? ret : List.of();
    }

    private static int multiplyColor(int color1, int color2) {
        if (color1 == -1) {
            return color2;
        }
        if (color2 == -1) {
            return color1;
        }
        int alpha = (color1 >> 24 & 0xFF) * (color2 >> 24 & 0xFF) / 255;
        int red = (color1 >> 16 & 0xFF) * (color2 >> 16 & 0xFF) / 255;
        int green = (color1 >> 8 & 0xFF) * (color2 >> 8 & 0xFF) / 255;
        int blue = (color1 & 0xFF) * (color2 & 0xFF) / 255;
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    private static int getColor(int[] quadData, int vertex) {
        return PipeBakedModel.swapBlueRed(quadData[vertex * QUAD_STRIDE + 3]);
    }

    private static void setColor(int[] quadData, int vertex, int color) {
        quadData[vertex * PipeBakedModel.QUAD_STRIDE + 3] = PipeBakedModel.swapBlueRed(color);
    }

    public static int swapBlueRed(int color) {
        if (color == -1) {
            return -1;
        }
        return color & 0xFF00FF00 | (color & 0xFF0000) >>> 16 | (color & 0xFF) << 16;
    }

    private static PipeRenderContext.QuadTransform getColorTransform(int color) {
        return quad -> {
            if (quad.tag() == 0) {
                quad.color(color, color, color, color);
            }
            return true;
        };
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.particleSprite;
    }

    public ItemTransforms getTransforms() {
        return ModelHelper.MODEL_TRANSFORM_BLOCK;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        Item item = itemStack.getItem();
        if (item instanceof PipeItem) {
            PipeItem pipe = (PipeItem)item;
            final PipeNetworkType type = pipe.type;
            final int color = type.getColor();
            return List.of(new PipeBakedModel(this.particleSprite, this.renderers, this.meWireConnectors, this.spriteFinder){

                @Override
                public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
                    if (side != null) {
                        return List.of();
                    }
                    PipeRenderContext renderContext = new PipeRenderContext(PipeBakedModel.this.spriteFinder, true, true);
                    renderContext.pushTransform(PipeBakedModel.getColorTransform(color));
                    renderContext.pushTransform(ITEM_TRANSFORM);
                    PipeEndpointType[][] connections = new PipeEndpointType[][]{{null, null, null, null, PipeEndpointType.BLOCK, PipeEndpointType.BLOCK}};
                    PipeBakedModel.this.renderers.get(PipeRenderer.get(type)).draw(null, null, renderContext, 0, connections, new CompoundTag());
                    renderContext.popTransform();
                    renderContext.popTransform();
                    return renderContext.quads;
                }
            });
        }
        return List.of(this);
    }

    private record ExtraData(BlockAndTintGetter level, BlockPos pos) {
        private static final ModelProperty<ExtraData> KEY = new ModelProperty();
    }
}

