/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.thirdparty.fabrictransfer.api.bridge;

import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.base.SingleSlotStorage;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import com.google.common.primitives.Ints;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class SlotFluidHandler
implements IFluidHandler {
    protected final SingleSlotStorage<FluidVariant> storage;

    public SlotFluidHandler(SingleSlotStorage<FluidVariant> storage) {
        this.storage = storage;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int slot) {
        return ((FluidVariant)this.storage.getResource()).toStack(Ints.saturatedCast((long)this.storage.getAmount()));
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        if (this.disallowIo() || stack.isEmpty()) {
            return 0;
        }
        try (Transaction tx = Transaction.hackyOpen();){
            long inserted = this.storage.insert(FluidVariant.of(stack), stack.getAmount(), tx);
            if (action.execute()) {
                tx.commit();
            }
            int n = (int)inserted;
            return n;
        }
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.disallowIo() || resource.isEmpty() || this.storage.isResourceBlank() || !((FluidVariant)this.storage.getResource()).matches(resource)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    public FluidStack drain(int amount, IFluidHandler.FluidAction action) {
        if (this.disallowIo() || amount <= 0) {
            return FluidStack.EMPTY;
        }
        try (Transaction tx = Transaction.hackyOpen();){
            FluidVariant resource = (FluidVariant)this.storage.getResource();
            if (resource.isBlank()) {
                FluidStack fluidStack = FluidStack.EMPTY;
                return fluidStack;
            }
            long extracted = this.storage.extract(resource, amount, tx);
            if (action.execute()) {
                tx.commit();
            }
            FluidStack fluidStack = extracted == 0L ? FluidStack.EMPTY : resource.toStack((int)extracted);
            return fluidStack;
        }
    }

    public int getTankCapacity(int slot) {
        return Ints.saturatedCast((long)this.storage.getCapacity());
    }

    public boolean isFluidValid(int slot, @NotNull FluidStack stack) {
        return true;
    }

    public SingleSlotStorage<FluidVariant> storage() {
        return this.storage;
    }

    protected boolean disallowIo() {
        return false;
    }
}

