/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.forgehammer;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerRecipe;
import aztech.modern_industrialization.items.ForgeTool;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ForgeHammerScreenHandler
extends AbstractContainerMenu {
    private final DataSlot selectedRecipe;
    private final List<RecipeHolder<ForgeHammerRecipe>> availableRecipes;
    public final Slot output;
    public final Slot tool;
    public final Slot input;
    private final ContainerLevelAccess context;
    private final Level world;
    private final Player player;
    private long lastSoundTime = 0L;
    private ItemStack inputStackCache = ItemStack.EMPTY;
    private ItemStack toolStackCache = ItemStack.EMPTY;

    public ForgeHammerScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL);
    }

    public ForgeHammerScreenHandler(int syncId, Inventory playerInventory, final ContainerLevelAccess context) {
        super(MIRegistries.FORGE_HAMMER_MENU.get(), syncId);
        this.context = context;
        this.selectedRecipe = DataSlot.standalone();
        this.availableRecipes = new ArrayList<RecipeHolder<ForgeHammerRecipe>>();
        this.world = playerInventory.player.level();
        this.player = playerInventory.player;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, i * 9 + j + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 142));
        }
        this.input = new Slot((Container)new SimpleContainer(1){

            public void setChanged() {
                super.setChanged();
                ForgeHammerScreenHandler.this.slotsChanged((Container)this);
            }
        }, 0, 34, 33);
        this.tool = new Slot(this, (Container)new SimpleContainer(1){

            public void setChanged() {
                super.setChanged();
                ForgeHammerScreenHandler.this.slotsChanged((Container)this);
            }
        }, 0, 8, 33){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ForgeTool.TAG);
            }
        };
        this.output = new Slot((Container)new ResultContainer(), 0, 143, 33){
            private int removeCount;
            {
                super(arg0, arg1, arg2, arg3);
                this.removeCount = 0;
            }

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public ItemStack remove(int pAmount) {
                ItemStack stack = super.remove(pAmount);
                this.removeCount += stack.getCount();
                return stack;
            }

            protected void onQuickCraft(ItemStack pStack, int pAmount) {
                this.removeCount += pAmount;
                this.checkTakeAchievements(pStack);
            }

            protected void onSwapCraft(int pNumItemsCrafted) {
                this.removeCount += pNumItemsCrafted;
            }

            protected void checkTakeAchievements(ItemStack pStack) {
                if (this.removeCount > 0) {
                    pStack.onCraftedBy(ForgeHammerScreenHandler.this.player.level(), ForgeHammerScreenHandler.this.player, this.removeCount);
                    this.removeCount = 0;
                }
            }

            public void onTake(Player player, ItemStack stack) {
                this.checkTakeAchievements(stack);
                ForgeHammerScreenHandler.this.onCraft();
                context.execute((world, pos) -> {
                    if (ForgeHammerScreenHandler.this.lastSoundTime < world.getGameTime()) {
                        world.playSound(null, pos, SoundEvents.SMITHING_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        ForgeHammerScreenHandler.this.lastSoundTime = world.getGameTime();
                    }
                });
            }
        };
        this.addSlot(this.input);
        this.addSlot(this.tool);
        this.addSlot(this.output);
        this.addDataSlot(this.selectedRecipe);
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.get();
    }

    public List<RecipeHolder<ForgeHammerRecipe>> getAvailableRecipes() {
        return this.availableRecipes;
    }

    public int getAvailableRecipeCount() {
        return this.availableRecipes.size();
    }

    private boolean isInBounds(int id) {
        return id >= 0 && id < this.availableRecipes.size();
    }

    public void slotsChanged(Container inventory) {
        if (!ItemStack.matches((ItemStack)this.inputStackCache, (ItemStack)this.input.getItem()) || !ItemStack.matches((ItemStack)this.toolStackCache, (ItemStack)this.tool.getItem())) {
            this.updateStatus();
        }
        super.slotsChanged(inventory);
    }

    public void updateStatus() {
        this.inputStackCache = this.input.getItem().copy();
        this.toolStackCache = this.tool.getItem().copy();
        RecipeHolder<ForgeHammerRecipe> old = this.isInBounds(this.selectedRecipe.get()) ? this.availableRecipes.get(this.selectedRecipe.get()) : null;
        this.availableRecipes.clear();
        this.selectedRecipe.set(-1);
        this.output.set(ItemStack.EMPTY);
        if (!this.input.getItem().isEmpty()) {
            HashSet<ItemVariant> outputs = new HashSet<ItemVariant>();
            ArrayList<RecipeHolder> recipes = new ArrayList<RecipeHolder>(this.world.getRecipeManager().getAllRecipesFor((RecipeType)MIRegistries.FORGE_HAMMER_RECIPE_TYPE.get()));
            recipes.sort(Comparator.comparing(h -> -((ForgeHammerRecipe)h.value()).hammerDamage()));
            for (RecipeHolder holder : recipes) {
                ForgeHammerRecipe recipe = (ForgeHammerRecipe)holder.value();
                if (!recipe.ingredient().test(this.input.getItem()) || recipe.count() > this.input.getItem().getCount()) continue;
                ItemVariant output = ItemVariant.of(recipe.result());
                if (recipe.hammerDamage() != 0 && !this.tool.getItem().isEmpty()) {
                    outputs.add(output);
                    this.availableRecipes.add((RecipeHolder<ForgeHammerRecipe>)holder);
                    continue;
                }
                if (recipe.hammerDamage() != 0 || outputs.contains(output)) continue;
                outputs.add(output);
                this.availableRecipes.add((RecipeHolder<ForgeHammerRecipe>)holder);
            }
            this.availableRecipes.sort(Comparator.comparing(RecipeHolder::id));
            for (int i = 0; i < this.availableRecipes.size(); ++i) {
                if (old != this.availableRecipes.get(i)) continue;
                this.selectedRecipe.set(i);
                break;
            }
            this.populateResult();
        }
    }

    void populateResult() {
        if (!this.availableRecipes.isEmpty() && this.isInBounds(this.selectedRecipe.get())) {
            RecipeHolder<ForgeHammerRecipe> current = this.availableRecipes.get(this.getSelectedRecipe());
            if (((ForgeHammerRecipe)current.value()).hammerDamage() == 0 || !this.tool.getItem().isEmpty() && this.tool.getItem().getDamageValue() < this.tool.getItem().getMaxDamage()) {
                this.output.set(((ForgeHammerRecipe)current.value()).result().copy());
            } else {
                this.output.set(ItemStack.EMPTY);
            }
        } else {
            this.output.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public boolean clickMenuButton(Player player, int id) {
        if (this.isInBounds(id)) {
            this.selectedRecipe.set(id);
            this.populateResult();
        }
        return true;
    }

    private void onCraft() {
        RecipeHolder<ForgeHammerRecipe> current = this.availableRecipes.get(this.selectedRecipe.get());
        this.input.getItem().shrink(((ForgeHammerRecipe)current.value()).count());
        if (!this.tool.getItem().isEmpty()) {
            if (!this.world.isClientSide()) {
                this.tool.getItem().hurtAndBreak(((ForgeHammerRecipe)current.value()).hammerDamage(), (ServerLevel)this.world, (ServerPlayer)this.player, item -> this.tool.set(ItemStack.EMPTY));
            }
            if (this.tool.getItem().getDamageValue() >= this.tool.getItem().getMaxDamage()) {
                this.tool.set(ItemStack.EMPTY);
                this.context.execute((world, pos) -> world.playSound(null, pos, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f));
            }
        } else if (((ForgeHammerRecipe)current.value()).hammerDamage() > 0) {
            throw new IllegalStateException("Forge Hammer Exception : Tool crafting without a tool");
        }
        this.updateStatus();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            Item item = itemStack2.getItem();
            itemStack = itemStack2.copy();
            if (index == 38) {
                item.onCraftedBy(itemStack2, player.level(), player);
                if (!this.moveItemStackTo(itemStack2, 0, 36, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemStack2, itemStack);
            } else if (index == 37 || index == 36) {
                if (!this.moveItemStackTo(itemStack2, 0, 36, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index < 36 && !this.moveItemStackTo(itemStack2, 36, 38, true)) {
                if (index < 27) {
                    if (!this.moveItemStackTo(itemStack2, 27, 36, false)) {
                        return ItemStack.EMPTY;
                    }
                } else {
                    return ItemStack.EMPTY;
                }
            }
            if (itemStack2.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack2);
            this.broadcastChanges();
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return (Boolean)this.context.evaluate((level, pos) -> level.getBlockState(pos).is((Block)MIBlock.FORGE_HAMMER.asBlock()) && player.canInteractWithBlock(pos, 4.0), (Object)true);
    }

    public void removed(Player player) {
        super.removed(player);
        this.context.execute((world, blockPos) -> {
            this.clearContainer(player, this.input.container);
            this.clearContainer(player, this.tool.container);
        });
    }

    public void moveRecipe(ResourceLocation recipeId, int fillAction, int amount) {
        RecipeHolder recipeHolder = this.world.getRecipeManager().getAllRecipesFor((RecipeType)MIRegistries.FORGE_HAMMER_RECIPE_TYPE.get()).stream().filter(r -> r.id().equals((Object)recipeId)).findFirst().orElse(null);
        if (recipeHolder == null) {
            return;
        }
        ForgeHammerRecipe recipe = (ForgeHammerRecipe)recipeHolder.value();
        boolean firstPass = true;
        while (amount > 0) {
            boolean didSomething = false;
            if (recipe.ingredient().test(this.input.getItem())) {
                int targetAmount = firstPass ? recipe.count() : this.input.getItem().getCount() + recipe.count();
                int delta = targetAmount - this.input.getItem().getCount();
                if (delta < 0) {
                    this.player.getInventory().placeItemBackInInventory(this.input.remove(-delta));
                    didSomething = true;
                } else {
                    toPull = delta;
                    for (i = 0; i < 36; ++i) {
                        slot = (Slot)this.slots.get(i);
                        if (!ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)this.input.getItem()) || (toMove = Math.min(toPull, this.input.getMaxStackSize(this.input.getItem()) - this.input.getItem().getCount())) <= 0) continue;
                        removed = slot.remove(toMove);
                        this.input.getItem().grow(removed.getCount());
                        this.input.setChanged();
                        toPull -= removed.getCount();
                        didSomething = true;
                    }
                }
            } else {
                ItemStack oldInput = this.input.remove(this.input.getItem().getCount());
                this.player.getInventory().placeItemBackInInventory(oldInput);
                ItemStack matchingStack = ItemStack.EMPTY;
                for (int i = 0; i < 36 && matchingStack.isEmpty(); ++i) {
                    Slot slot = (Slot)this.slots.get(i);
                    if (!recipe.ingredient().test(slot.getItem())) continue;
                    matchingStack = slot.getItem().copy();
                }
                if (matchingStack.isEmpty()) {
                    return;
                }
                toPull = recipe.count();
                this.input.set(matchingStack.copy());
                this.input.getItem().setCount(0);
                for (i = 0; i < 36; ++i) {
                    slot = (Slot)this.slots.get(i);
                    if (!ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)matchingStack) || (toMove = Math.min(toPull, this.input.getMaxStackSize(this.input.getItem()) - this.input.getItem().getCount())) <= 0) continue;
                    removed = slot.remove(toMove);
                    this.input.getItem().grow(removed.getCount());
                    this.input.setChanged();
                    toPull -= removed.getCount();
                    didSomething = true;
                }
            }
            if (recipe.hammerDamage() > 0 && !this.tool.hasItem()) {
                for (int i = 0; i < 36; ++i) {
                    Slot slot = (Slot)this.slots.get(i);
                    if (!slot.getItem().is(ForgeTool.TAG)) continue;
                    this.tool.set(slot.remove(1));
                    didSomething = true;
                    break;
                }
            }
            int recipeIndex = -1;
            for (int i = 0; i < this.availableRecipes.size(); ++i) {
                if (!this.availableRecipes.get(i).id().equals((Object)recipeId)) continue;
                recipeIndex = i;
                break;
            }
            if (recipeIndex == -1) {
                return;
            }
            if (this.selectedRecipe.get() != recipeIndex) {
                this.selectedRecipe.set(recipeIndex);
                didSomething = true;
            }
            this.populateResult();
            ItemStack oldOutput = this.output.getItem().copy();
            switch (fillAction) {
                case 1: {
                    this.clicked(this.output.index, 0, ClickType.PICKUP, this.player);
                    break;
                }
                case 2: {
                    this.clicked(this.output.index, 0, ClickType.QUICK_MOVE, this.player);
                }
            }
            if (!ItemStack.matches((ItemStack)oldOutput, (ItemStack)this.output.getItem())) {
                didSomething = true;
            }
            --amount;
            if (!didSomething && !firstPass) break;
            firstPass = false;
        }
    }
}

