/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.jade.server;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.blocks.storage.tank.TankBlockEntity;
import aztech.modern_industrialization.compat.jade.server.MIJadeCommonPlugin;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;

public class TankComponentProvider
implements IServerExtensionProvider<CompoundTag>,
IClientExtensionProvider<CompoundTag, FluidView> {
    public List<ViewGroup<CompoundTag>> getGroups(Accessor<?> accessor) {
        TankBlockEntity tank = (TankBlockEntity)accessor.getTarget();
        return List.of(new ViewGroup(List.of(FluidView.writeDefault((JadeFluidObject)MIJadeCommonPlugin.fluidStack((FluidVariant)tank.getResource(), tank.getAmount()), (long)tank.getCapacity()))));
    }

    public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> list) {
        return ClientViewGroup.map(list, TankComponentProvider::readFluidViewLong, null);
    }

    @Nullable
    public static FluidView readFluidViewLong(CompoundTag tag) {
        long capacity = tag.getLong("capacity");
        if (capacity <= 0L) {
            return null;
        }
        JadeFluidObject fluidObject = JadeFluidObject.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("fluid")).result().orElse(null);
        if (fluidObject == null) {
            return null;
        }
        long amount = fluidObject.getAmount();
        FluidView fluidView = new FluidView(IElementHelper.get().fluid(fluidObject));
        fluidView.fluidName = new FluidStack((Holder)fluidObject.getType().builtInRegistryHolder(), 1, fluidObject.getComponents()).getHoverName();
        fluidView.current = IDisplayHelper.get().humanReadableNumber((double)amount, "B", true);
        fluidView.max = IDisplayHelper.get().humanReadableNumber((double)capacity, "B", true);
        fluidView.ratio = (float)((double)amount / (double)capacity);
        if (fluidObject.getType().isSame(Fluids.EMPTY)) {
            fluidView.overrideText = Component.translatable((String)"jade.fluid", (Object[])new Object[]{FluidView.EMPTY_FLUID, Component.literal((String)fluidView.max).withStyle(ChatFormatting.GRAY)});
        }
        return fluidView;
    }

    public ResourceLocation getUid() {
        return MI.id("tank");
    }
}

