/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.config;

import aztech.modern_industrialization.config.MIConfigBuilder;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class MIServerConfig {
    public static final MIServerConfig INSTANCE;
    public static final ModConfigSpec SPEC;
    public final ModConfigSpec.IntValue forgeEnergyPerEu;
    public final ModConfigSpec.IntValue baseItemPipeTransfer;
    public final ModConfigSpec.BooleanValue spawnWithGuideBook;
    public final ModConfigSpec.BooleanValue respawnWithGuideBook;
    public final ModConfigSpec.BooleanValue compostableToPlantOil;
    public final ModConfigSpec.BooleanValue stonecutterToCuttingMachine;

    private MIServerConfig(MIConfigBuilder builder) {
        this.forgeEnergyPerEu = builder.start("forgeEnergyPerEu", "FE per EU", "How many Forge Energy units a single EU from MI is worth.").defineInRange("forgeEnergyPerEu", 10, 1, 1000);
        this.baseItemPipeTransfer = builder.start("baseItemPipeTransfer", "Base item pipe transfer", "Base amount of items transferred by item pipes every 3 seconds.").defineInRange("baseItemPipeTransfer", 16, 1, 1024);
        this.spawnWithGuideBook = builder.start("spawnWithGuideBook", "Spawn with guidebook", "Grant guidebook the first time a player joins the server.").define("spawnWithGuideBook", true);
        this.respawnWithGuideBook = builder.start("respawnWithGuideBook", "Respawn with guidebook", "Grant guidebook when a player respawns after death.").define("respawnWithGuideBook", true);
        builder.pushSection("recipes", "Recipes");
        this.compostableToPlantOil = builder.start("compostableToPlantOil", "Compostable plant oil recipes", "Generate plant oil recipes in the centrifuge for all compostable items.").define("compostableToPlantOil", true);
        this.stonecutterToCuttingMachine = builder.start("stonecutterToCuttingMachine", "Stonecutter cutting machine recipes", "Generate cutting machine recipes for all stonecutter recipes.").define("stonecutterToCuttingMachine", true);
        builder.popSection();
    }

    static {
        MIConfigBuilder builder = new MIConfigBuilder();
        INSTANCE = new MIServerConfig(builder);
        SPEC = builder.build();
    }
}

