/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.compat.sodium.SodiumCompat;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.models.MachineBakedModel;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.ModelHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.IdentityHashMap;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jetbrains.annotations.Nullable;

public class MachineBlockEntityRenderer<T extends MachineBlockEntity>
implements BlockEntityRenderer<T> {
    private final BlockModelShaper blockModels;
    private BlockState lastBlockState = null;
    @Nullable
    private MachineBakedModel model = null;
    private final IdentityHashMap<MachineCasing, Object[]> quadCache = new IdentityHashMap();
    private static final Object NO_QUAD = new Object();

    public MachineBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.blockModels = ctx.getBlockRenderDispatcher().getBlockModelShaper();
    }

    @Nullable
    private BakedQuad getCachedQuad(MachineModelClientData data, Direction d) {
        Object quad;
        Direction facing = data.frontDirection;
        int cachedQuadIndex = facing.ordinal() * 6 + d.ordinal();
        MachineCasing casing = data.casing;
        Object[] cachedQuads = this.quadCache.computeIfAbsent(casing, c -> new Object[36]);
        if (cachedQuads[cachedQuadIndex] == null) {
            TextureAtlasSprite sprite;
            TextureAtlasSprite textureAtlasSprite = sprite = this.model == null ? null : MachineBakedModel.getSprite(this.model.getSprites(casing), d, facing, true);
            if (sprite != null) {
                QuadBakingVertexConsumer vc = new QuadBakingVertexConsumer();
                cachedQuads[cachedQuadIndex] = ModelHelper.bakeSprite(vc, d, sprite, -2.0f * MachineBakedModel.Z_OFFSET);
            } else {
                cachedQuads[cachedQuadIndex] = NO_QUAD;
            }
        }
        return (quad = cachedQuads[cachedQuadIndex]) == NO_QUAD ? null : (BakedQuad)quad;
    }

    @Nullable
    private MachineBakedModel getMachineModel(BlockState state) {
        BakedModel bakedModel = this.blockModels.getBlockModel(state);
        if (bakedModel instanceof MachineBakedModel) {
            MachineBakedModel mbm = (MachineBakedModel)bakedModel;
            return mbm;
        }
        MI.LOGGER.warn("Model {} should have been a MachineBakedModel, but was {}", (Object)state, (Object)this.blockModels.getBlockModel(state).getClass());
        return null;
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vcp, int light, int overlay) {
        BlockState state = entity.getBlockState();
        if (this.lastBlockState == null) {
            this.lastBlockState = state;
            this.model = this.getMachineModel(state);
        } else if (this.lastBlockState != state) {
            throw new IllegalStateException("Tried to use the same machine BER with two block states: " + String.valueOf(state) + " and " + String.valueOf(this.lastBlockState));
        }
        MachineModelClientData data = ((MachineBlockEntity)entity).getMachineModelData();
        if (data.isActive) {
            VertexConsumer vc = vcp.getBuffer(Sheets.cutoutBlockSheet());
            for (Direction d : Direction.values()) {
                BakedQuad quad = this.getCachedQuad(data, d);
                if (quad == null) continue;
                int faceLight = LevelRenderer.getLightColor((BlockAndTintGetter)entity.getLevel(), (BlockState)entity.getBlockState(), (BlockPos)entity.getBlockPos().relative(d));
                vc.putBulkData(matrices.last(), quad, 1.0f, 1.0f, 1.0f, 1.0f, faceLight, OverlayTexture.NO_OVERLAY);
                SodiumCompat.markSpriteActive(quad.getSprite());
            }
        }
    }

    public int getViewDistance() {
        return 256;
    }
}

