/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.api.machine.holder.MultiblockInventoryComponentHolder;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.ActiveShapeComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.FluidItemConsumerComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MultiblockInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.RedstoneControlComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.util.Simulation;
import aztech.modern_industrialization.util.Tickable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;

public class GeneratorMultiblockBlockEntity
extends MultiblockMachineBlockEntity
implements Tickable,
EnergyListComponentHolder,
MultiblockInventoryComponentHolder {
    private boolean allowNormalOperation = false;
    private final ActiveShapeComponent activeShape;
    private final MultiblockInventoryComponent inventory;
    private final IsActiveComponent isActiveComponent;
    private final RedstoneControlComponent redstoneControl;
    private final List<EnergyComponent> energyOutputs = new ArrayList<EnergyComponent>();
    private final FluidItemConsumerComponent fluidConsumer;

    public GeneratorMultiblockBlockEntity(BEP bep, String name, ShapeTemplate shapeTemplate, FluidItemConsumerComponent fluidConsumer) {
        super(bep, new MachineGuiParameters.Builder(name, false).backgroundHeight(128).build(), new OrientationComponent.Params(false, false, false));
        this.activeShape = new ActiveShapeComponent(new ShapeTemplate[]{shapeTemplate});
        this.inventory = new MultiblockInventoryComponent();
        this.isActiveComponent = new IsActiveComponent();
        this.fluidConsumer = fluidConsumer;
        this.redstoneControl = new RedstoneControlComponent();
        this.registerComponents(this.activeShape, this.isActiveComponent, fluidConsumer, this.redstoneControl);
        this.registerGuiComponent(new SlotPanel.Server(this).withRedstoneControl(this.redstoneControl));
    }

    @Override
    public ShapeTemplate getActiveShape() {
        return this.activeShape.getActiveShape();
    }

    public List<EnergyComponent> getEnergyComponents() {
        return this.energyOutputs;
    }

    @Override
    public MultiblockInventoryComponent getMultiblockInventoryComponent() {
        return this.inventory;
    }

    @Override
    public final MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    protected final MachineModelClientData getMachineModelData() {
        return new MachineModelClientData(null, this.orientation.facingDirection).active(this.isActiveComponent.isActive);
    }

    @Override
    public final void tick() {
        if (!this.level.isClientSide) {
            this.link();
            if (this.allowNormalOperation) {
                if (this.redstoneControl.doAllowNormalOperation(this)) {
                    long euProduced = this.fluidConsumer.getEuProduction(this.inventory.getFluidInputs(), this.inventory.getItemInputs(), this.insertEnergy(Long.MAX_VALUE, Simulation.SIMULATE));
                    this.insertEnergy(euProduced, Simulation.ACT);
                    this.isActiveComponent.updateActive(euProduced != 0L, this);
                } else {
                    this.isActiveComponent.updateActive(false, this);
                }
            } else {
                this.isActiveComponent.updateActive(false, this);
            }
            this.setChanged();
        }
    }

    public long insertEnergy(long value, Simulation simulation) {
        long rem = value;
        long inserted = 0L;
        for (EnergyComponent e : this.energyOutputs) {
            if (rem <= 0L) continue;
            rem -= (inserted += e.insertEu(rem, simulation));
        }
        return inserted;
    }

    @Override
    protected void onRematch(ShapeMatcher shapeMatcher) {
        this.allowNormalOperation = false;
        if (shapeMatcher.isMatchSuccessful()) {
            this.inventory.rebuild(shapeMatcher);
            this.allowNormalOperation = true;
            this.energyOutputs.clear();
            for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
                hatch.appendEnergyOutputs(this.energyOutputs);
            }
        }
    }

    @Override
    public List<Component> getTooltips() {
        return this.fluidConsumer.getTooltips();
    }
}

