/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.ProgressBar;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class ProgressBarClient
implements GuiComponentClient {
    public final ProgressBar.Parameters params;
    public float progress;

    public ProgressBarClient(RegistryFriendlyByteBuf buf) {
        this.params = new ProgressBar.Parameters(buf.readInt(), buf.readInt(), buf.readUtf(), buf.readBoolean());
        this.readCurrentData(buf);
    }

    public static void renderProgress(GuiGraphics guiGraphics, int x, int y, ProgressBar.Parameters params, float progress) {
        guiGraphics.blit(params.getTextureId(), x + params.renderX, y + params.renderY, 0.0f, 0.0f, 20, 20, 20, 40);
        int foregroundPixels = (int)(progress * 20.0f);
        if (foregroundPixels > 0) {
            if (!params.isVertical) {
                guiGraphics.blit(params.getTextureId(), x + params.renderX, y + params.renderY, 0.0f, 20.0f, foregroundPixels, 20, 20, 40);
            } else {
                guiGraphics.blit(params.getTextureId(), x + params.renderX, y + params.renderY + 20 - foregroundPixels, 0.0f, (float)(40 - foregroundPixels), 20, foregroundPixels, 20, 40);
            }
        }
    }

    @Override
    public void readCurrentData(RegistryFriendlyByteBuf buf) {
        this.progress = buf.readFloat();
    }

    @Override
    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    public class Renderer
    implements ClientComponentRenderer {
        @Override
        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
            ProgressBarClient.renderProgress(guiGraphics, x, y, ProgressBarClient.this.params, ProgressBarClient.this.progress);
        }
    }
}

