/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import ooo.foooooooooooo.velocitydiscord.VelocityListener;
import ooo.foooooooooooo.velocitydiscord.commands.Commands;
import ooo.foooooooooooo.velocitydiscord.compat.LuckPerms;
import ooo.foooooooooooo.velocitydiscord.config.PluginConfig;
import ooo.foooooooooooo.velocitydiscord.discord.Discord;
import ooo.foooooooooooo.velocitydiscord.yep.YepListener;
import org.slf4j.Logger;

@Plugin(id="discord", name="Velocity Discord Bridge", description="Velocity Discord Chat Bridge", version="2.0.0", url="https://github.com/fooooooooooooooo/VelocityDiscord", authors={"fooooooooooooooo"}, dependencies={@Dependency(id="yeplib", optional=true), @Dependency(id="luckperms", optional=true)})
public class VelocityDiscord {
    public static final MinecraftChannelIdentifier YepIdentifier = MinecraftChannelIdentifier.create((String)"velocity", (String)"yep");
    public static Logger LOGGER;
    public static PluginConfig CONFIG;
    public static ProxyServer SERVER;
    public static boolean pluginDisabled;
    private static VelocityDiscord instance;
    private final Path dataDirectory;
    @Nullable
    private VelocityListener listener = null;
    @Nullable
    private Discord discord = null;
    @Nullable
    private YepListener yep = null;
    @Nullable
    private LuckPerms luckPerms = null;
    private ScheduledTask pingScheduler = null;
    private ScheduledTask topicScheduler = null;

    @Inject
    public VelocityDiscord(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        SERVER = server;
        LOGGER = logger;
        this.dataDirectory = dataDirectory;
        LOGGER.info("Loading {} v{}", (Object)"Velocity Discord Bridge", (Object)"2.0.0");
        this.reloadConfig();
        instance = this;
        if (pluginDisabled || CONFIG == null) {
            return;
        }
        this.discord = new Discord();
        if (server.getPluginManager().isLoaded("yeplib")) {
            this.yep = new YepListener();
        }
        this.listener = new VelocityListener(this.discord);
    }

    public static Discord getDiscord() {
        return VelocityDiscord.instance.discord;
    }

    public static VelocityListener getListener() {
        return VelocityDiscord.instance.listener;
    }

    public static VelocityDiscord getInstance() {
        return instance;
    }

    public static LuckPerms getLuckPerms() {
        return VelocityDiscord.instance.luckPerms;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        if (this.listener != null) {
            this.register(this.listener);
        }
        if (this.yep != null) {
            this.register(this.yep);
        }
        SERVER.getChannelRegistrar().register(new ChannelIdentifier[]{YepIdentifier});
        if (CONFIG != null) {
            this.tryStartPingScheduler();
            this.tryStartTopicScheduler();
        }
        Commands.registerCommands(SERVER.getCommandManager(), CONFIG);
        try {
            if (SERVER.getPluginManager().getPlugin("luckperms").isPresent()) {
                this.luckPerms = new LuckPerms();
                LOGGER.info("LuckPerms found, prefix can be displayed");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error getting LuckPerms instance: {}", (Object)e.getMessage());
        }
        finally {
            if (this.luckPerms == null) {
                LOGGER.info("LuckPerms not found, prefix will not be displayed");
            }
        }
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        if (this.discord != null) {
            this.discord.shutdown();
        }
    }

    private void register(Object listener) {
        SERVER.getEventManager().register((Object)this, listener);
    }

    public String reloadConfig() {
        String error = null;
        if (CONFIG == null) {
            CONFIG = new PluginConfig(this.dataDirectory);
        } else {
            LOGGER.info("Reloading config");
            error = CONFIG.reloadConfig(this.dataDirectory);
            if (VelocityDiscord.CONFIG.global.pingIntervalSeconds == 0 && this.pingScheduler != null) {
                this.pingScheduler.cancel();
                this.pingScheduler = null;
            }
            this.tryStartPingScheduler();
            if (VelocityDiscord.CONFIG.global.discord.updateChannelTopicIntervalMinutes == 0 && this.topicScheduler != null) {
                this.topicScheduler.cancel();
                this.topicScheduler = null;
            }
            this.tryStartTopicScheduler();
            if (this.discord != null) {
                this.discord.onConfigReload();
            }
            Commands.unregisterCommands(SERVER.getCommandManager());
            Commands.registerCommands(SERVER.getCommandManager(), CONFIG);
            if (error != null) {
                LOGGER.error("Error reloading config:");
                for (String line : error.split("\n")) {
                    LOGGER.error(line);
                }
            } else {
                LOGGER.info("Config reloaded");
            }
        }
        pluginDisabled = CONFIG.isConfigNotSetup();
        if (pluginDisabled) {
            LOGGER.error("This is the first time you are running this plugin. Please configure it in the config.toml file. Disabling plugin.");
        }
        return error;
    }

    private void tryStartPingScheduler() {
        if (VelocityDiscord.CONFIG.global.pingIntervalEnabled() || this.pingScheduler != null) {
            this.pingScheduler = SERVER.getScheduler().buildTask((Object)this, () -> {
                if (this.listener != null) {
                    this.listener.checkServerHealth();
                }
            }).repeat((long)VelocityDiscord.CONFIG.global.pingIntervalSeconds, TimeUnit.SECONDS).schedule();
        }
    }

    private void tryStartTopicScheduler() {
        if (!VelocityDiscord.CONFIG.global.discord.updateChannelTopicEnabled()) {
            return;
        }
        int interval = VelocityDiscord.CONFIG.global.discord.updateChannelTopicIntervalMinutes;
        if (interval < 10) {
            LOGGER.warn("Invalid update_channel_topic_interval value: {}. Must be between > 10, setting to 10", (Object)interval);
            interval = 10;
        }
        this.topicScheduler = SERVER.getScheduler().buildTask((Object)this, () -> {
            LOGGER.debug("Updating channel topic");
            if (this.discord != null) {
                this.discord.updateChannelTopic();
            }
        }).repeat((long)interval, TimeUnit.MINUTES).schedule();
        LOGGER.info("Scheduled task to update channel topic every {} minutes", (Object)interval);
    }

    static {
        pluginDisabled = false;
    }
}

