/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.luckperms.api.model.user.User;
import ooo.foooooooooooo.velocitydiscord.VelocityDiscord;
import ooo.foooooooooooo.velocitydiscord.compat.LuckPerms;
import ooo.foooooooooooo.velocitydiscord.discord.Discord;

public class VelocityListener {
    private final Discord discord;
    private final Map<String, ServerState> serverState = new HashMap<String, ServerState>();
    private boolean firstHealthCheck = true;

    public VelocityListener(Discord discord) {
        this.discord = discord;
    }

    @Subscribe
    public void onPlayerChat(PlayerChatEvent event) {
        Optional currentServer = event.getPlayer().getCurrentServer();
        if (currentServer.isEmpty()) {
            return;
        }
        String server = ((ServerConnection)currentServer.get()).getServerInfo().getName();
        if (VelocityDiscord.CONFIG.serverDisabled(server)) {
            return;
        }
        String username = event.getPlayer().getUsername();
        UUID uuid = event.getPlayer().getUniqueId();
        Optional<String> prefix = this.getPrefix(uuid);
        this.discord.onPlayerChat(username, uuid.toString(), prefix, server, event.getMessage());
    }

    @Subscribe
    public void onConnect(ServerConnectedEvent event) {
        this.updatePlayerCount();
        String server = event.getServer().getServerInfo().getName();
        if (VelocityDiscord.CONFIG.serverDisabled(server)) {
            return;
        }
        this.setServerOnline(server);
        String username = event.getPlayer().getUsername();
        Optional previousServer = event.getPreviousServer();
        String previousName = previousServer.map(s -> s.getServerInfo().getName()).orElse(null);
        UUID uuid = event.getPlayer().getUniqueId();
        Optional<String> prefix = this.getPrefix(uuid);
        if (previousServer.isPresent() && !VelocityDiscord.CONFIG.serverDisabled(previousName)) {
            this.discord.onServerSwitch(username, uuid.toString(), prefix, server, previousName);
        } else {
            this.discord.onJoin(event.getPlayer(), prefix, server);
        }
    }

    @Subscribe
    public void onDisconnect(DisconnectEvent event) {
        this.updatePlayerCount();
        Optional currentServer = event.getPlayer().getCurrentServer();
        String username = event.getPlayer().getUsername();
        UUID uuid = event.getPlayer().getUniqueId();
        Optional<String> prefix = this.getPrefix(uuid);
        if (currentServer.isEmpty()) {
            this.discord.onDisconnect(username, uuid.toString(), prefix, "");
        } else {
            String name = ((ServerConnection)currentServer.get()).getServerInfo().getName();
            if (VelocityDiscord.CONFIG.serverDisabled(name)) {
                return;
            }
            this.setServerOnline(name);
            this.discord.onLeave(username, uuid.toString(), prefix, name);
        }
    }

    @Subscribe
    public void onProxyInitialize(ProxyInitializeEvent event) {
        this.discord.onProxyInitialize();
        this.updatePlayerCount();
        this.checkServerHealth();
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.discord.onProxyShutdown();
    }

    private void onServerOffline(String server) {
        this.discord.onServerStop(server);
    }

    private void onServerOnline(String server) {
        this.discord.onServerStart(server);
    }

    private void updatePlayerCount() {
        this.discord.updateActivityPlayerAmount(VelocityDiscord.SERVER.getPlayerCount());
    }

    private Optional<String> getPrefix(UUID uuid) {
        LuckPerms luckPerms = VelocityDiscord.getLuckPerms();
        if (luckPerms == null) {
            return Optional.empty();
        }
        User user = luckPerms.getUserManager().getUser(uuid);
        if (user != null) {
            return Optional.ofNullable(user.getCachedData().getMetaData().getPrefix());
        }
        return Optional.empty();
    }

    public void checkServerHealth() {
        Collection servers = VelocityDiscord.SERVER.getAllServers();
        CompletableFuture.allOf((CompletableFuture[])servers.parallelStream().map(server -> server.ping().handle((ping, ex) -> this.handlePing((RegisteredServer)server, (ServerPing)ping, (Throwable)ex))).toArray(CompletableFuture[]::new)).join();
        this.firstHealthCheck = false;
    }

    private CompletableFuture<Void> handlePing(RegisteredServer server, ServerPing ping, Throwable ex) {
        String name = server.getServerInfo().getName();
        if (VelocityDiscord.CONFIG.serverDisabled(name)) {
            return CompletableFuture.completedFuture(null);
        }
        ServerState state = this.serverState.getOrDefault(name, ServerState.empty());
        if (ex != null) {
            if (state.online) {
                if (!this.firstHealthCheck) {
                    this.onServerOffline(name);
                }
                state.online = false;
                this.serverState.put(name, state);
            }
            return CompletableFuture.completedFuture(null);
        }
        if (!state.online && !this.firstHealthCheck) {
            this.onServerOnline(name);
        }
        int players = 0;
        int maxPlayers = 0;
        if (ping.getPlayers().isPresent()) {
            players = ((ServerPing.Players)ping.getPlayers().get()).getOnline();
            maxPlayers = ((ServerPing.Players)ping.getPlayers().get()).getMax();
        }
        state.online = true;
        state.players = players;
        state.maxPlayers = maxPlayers;
        this.serverState.put(name, state);
        return CompletableFuture.completedFuture(null);
    }

    public ServerState getServerState(RegisteredServer server) {
        String name = server.getServerInfo().getName();
        return this.serverState.getOrDefault(name, ServerState.empty());
    }

    private void setServerOnline(String server) {
        ServerState state = this.serverState.getOrDefault(server, ServerState.empty());
        if (!state.online) {
            this.onServerOnline(server);
            state.online = true;
            this.serverState.put(server, state);
        }
    }

    public static class ServerState {
        public boolean online;
        public int players;
        public int maxPlayers;

        public ServerState(boolean online, int players, int maxPlayers) {
            this.online = online;
            this.players = players;
            this.maxPlayers = maxPlayers;
        }

        public static ServerState empty() {
            return new ServerState(false, 0, 0);
        }
    }
}

