/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord.config;

import com.electronwill.nightconfig.core.Config;
import java.awt.Color;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nullable;

public class Config {
    private static final String INVALID_VALUE_FORMAT_STRING = "ERROR: `%s` is not a valid value for `%s`, acceptable values: `false`, any string";
    public static final Color GREEN = new Color(4243279);
    public static final Color RED = new Color(12533824);
    private final com.electronwill.nightconfig.core.Config config;

    public Config(com.electronwill.nightconfig.core.Config config) {
        this.config = config;
    }

    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    public <T> T getOrDefault(String key, T defaultValue) {
        return (T)this.config.getOrElse(key, defaultValue);
    }

    public <T> T get(String key) {
        return (T)this.config.get(key);
    }

    public <T> HashMap<String, T> getMapOrDefault(String key, HashMap<String, T> defaultValue) {
        Object value = this.config.getRaw(key);
        if (value instanceof com.electronwill.nightconfig.core.Config) {
            com.electronwill.nightconfig.core.Config subConfig = (com.electronwill.nightconfig.core.Config)value;
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Config.Entry entry : subConfig.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            return map;
        }
        if (value == null) {
            return defaultValue;
        }
        throw new RuntimeException(String.format("ERROR: `%s` is not a valid map for `%s`", value, key));
    }

    @Nullable
    public Config getConfig(String key) {
        Object value = this.config.getRaw(key);
        if (value instanceof com.electronwill.nightconfig.core.Config) {
            com.electronwill.nightconfig.core.Config subConfig = (com.electronwill.nightconfig.core.Config)value;
            return new Config(subConfig);
        }
        if (value == null) {
            return null;
        }
        throw new RuntimeException(String.format("ERROR: `%s` is not a valid config for `%s`", value, key));
    }

    public Optional<String> getOptional(String key, Optional<String> defaultValue) {
        Object value;
        Object object = value = this.config.getRaw(key);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, String.class}, (Object)object, n)) {
            case -1: {
                return defaultValue;
            }
            case 0: {
                Boolean bool = (Boolean)object;
                if (!bool.booleanValue()) {
                    return Optional.empty();
                }
                throw new RuntimeException(String.format(INVALID_VALUE_FORMAT_STRING, "true", key));
            }
            case 1: {
                String str = (String)object;
                if (str.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(str);
            }
        }
        throw new RuntimeException(String.format(INVALID_VALUE_FORMAT_STRING, value, key));
    }

    public Optional<String> getDisableableString(String path) {
        return this.getOptional(path, Optional.empty());
    }

    public Optional<String> getDisableableStringOrDefault(String path, Optional<String> defaultValue) {
        return this.getOptional(path, defaultValue);
    }

    public Color getColor(String path) {
        return Color.decode((String)this.config.get(path));
    }

    public Color getColorOrDefault(String path, Color defaultValue) {
        return Color.decode(this.getOrDefault(path, Config.encodeColor(defaultValue)));
    }

    public Optional<Color> getDisableableColor(String path) {
        return this.getDisableableString(path).map(Color::decode);
    }

    public Optional<Color> getDisableableColorOrDefault(String path, Optional<Color> defaultValue) {
        return this.getDisableableStringOrDefault(path, defaultValue.map(Config::encodeColor)).map(Color::decode);
    }

    public static String encodeColor(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }
}

