/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import ooo.foooooooooooo.velocitydiscord.config.Config;
import ooo.foooooooooooo.velocitydiscord.config.ServerConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.ChatConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.DiscordConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.GlobalConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.LocalConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.MinecraftConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfig
implements ServerConfig {
    private static final Logger logger = LoggerFactory.getLogger(PluginConfig.class);
    private static final String[] splitVersion = "2.0.0".split("\\.");
    public static final String ConfigVersion = splitVersion[0] + "." + splitVersion[1];
    private static final String configMajorVersion = splitVersion[0];
    private static boolean configCreatedThisRun = false;
    private HashMap<String, ServerOverrideConfig> serverOverridesMap = new HashMap();
    private Config config;
    public GlobalConfig global = new GlobalConfig();
    public LocalConfig local = new LocalConfig();

    public PluginConfig(Path dataDir) {
        this.config = PluginConfig.loadFile(dataDir);
        this.loadConfig();
        this.onLoad();
    }

    public PluginConfig(Config config) {
        this.config = config;
        this.loadConfig();
        this.onLoad();
    }

    private void loadConfig() {
        if (this.config == null || this.config.isEmpty()) {
            throw new RuntimeException("ERROR: Config is empty");
        }
        this.global.load(this.config);
        this.local.load(this.config);
    }

    private void onLoad() {
        String error = PluginConfig.checkErrors(this.config);
        if (error != null) {
            logger.error(error);
        }
        if ((error = this.local.checkErrors()) != null) {
            logger.error(error);
        }
        this.serverOverridesMap = PluginConfig.loadOverrides(this.global, this.config);
    }

    private static Config loadFile(Path dataDir) {
        Path configFile;
        if (Files.notExists(dataDir, new LinkOption[0])) {
            try {
                Files.createDirectory(dataDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("ERROR: Could not create data directory at " + String.valueOf(dataDir.toAbsolutePath()));
            }
        }
        if (Files.notExists(configFile = dataDir.resolve("config.toml"), new LinkOption[0])) {
            configCreatedThisRun = true;
            try (InputStream in = PluginConfig.class.getResourceAsStream("/config.toml");){
                Files.copy(Objects.requireNonNull(in), configFile, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("ERROR: Can't write default configuration file (permissions/filesystem error?)");
            }
        }
        FileConfig fileConfig = FileConfig.of((Path)configFile);
        fileConfig.load();
        return new Config((com.electronwill.nightconfig.core.Config)fileConfig);
    }

    private static boolean versionCompatible(String newVersion) {
        return newVersion != null && newVersion.split("\\.")[0].equals(configMajorVersion);
    }

    @Nullable
    private static String checkErrors(Config config) {
        if (config == null || config.isEmpty()) {
            return "ERROR: Config is empty";
        }
        String version = (String)config.get("config_version");
        if (!PluginConfig.versionCompatible(version)) {
            return String.format("ERROR: Can't use the existing configuration file: version mismatch (mod: %s, config: %s)", ConfigVersion, version);
        }
        return null;
    }

    public boolean isConfigNotSetup() {
        return configCreatedThisRun || this.global.discord.isTokenUnset() || this.local.discord.isDefaultChannel();
    }

    public static HashMap<String, ServerOverrideConfig> loadOverrides(GlobalConfig baseGlobalConfig, Config baseConfig) {
        CommentedConfig overrideConfig = (CommentedConfig)baseConfig.get("override");
        if (overrideConfig == null) {
            logger.debug("No server overrides found");
            return new HashMap<String, ServerOverrideConfig>();
        }
        HashMap<String, ServerOverrideConfig> overrides = new HashMap<String, ServerOverrideConfig>();
        for (CommentedConfig.Entry entry : overrideConfig.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof com.electronwill.nightconfig.core.Config) {
                com.electronwill.nightconfig.core.Config serverOverride = (com.electronwill.nightconfig.core.Config)object;
                String serverName = entry.getKey();
                if (baseGlobalConfig.excludedServers.contains(serverName) && !baseGlobalConfig.excludedServersReceiveMessages) {
                    logger.info("Ignoring override for excluded server: {}", (Object)serverName);
                    continue;
                }
                Config config = new Config(serverOverride);
                overrides.put(serverName, new ServerOverrideConfig(baseConfig, config));
                continue;
            }
            logger.warn("Invalid server override for `{}`: `{}`", (Object)entry.getKey(), entry.getValue());
        }
        return overrides;
    }

    public boolean serverDisabled(String name) {
        return this.global.excludedServers.contains(name);
    }

    public String serverName(String name) {
        return this.global.serverDisplayNames.getOrDefault(name, name);
    }

    @Nullable
    public String reloadConfig(Path dataDirectory) {
        try {
            Config newConfig = PluginConfig.loadFile(dataDirectory);
            String errors = PluginConfig.checkErrors(newConfig);
            if (errors != null && !errors.isEmpty()) {
                return errors;
            }
            GlobalConfig newGlobal = new GlobalConfig();
            LocalConfig newLocal = new LocalConfig();
            newGlobal.load(newConfig);
            newLocal.load(newConfig);
            HashMap<String, ServerOverrideConfig> overrides = PluginConfig.loadOverrides(newGlobal, newConfig);
            errors = newLocal.checkErrors();
            if (errors != null && !errors.isEmpty()) {
                return errors;
            }
            this.serverOverridesMap = overrides;
            this.config = newConfig;
            this.global = newGlobal;
            this.local = newLocal;
            return null;
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
    }

    public ServerConfig getServerConfig(String serverName) {
        ServerOverrideConfig override = this.serverOverridesMap.get(serverName);
        if (override != null) {
            return override;
        }
        return this;
    }

    @Override
    public DiscordConfig getDiscordConfig() {
        return this.local.discord;
    }

    @Override
    public ChatConfig getChatConfig() {
        return this.local.discord.chat;
    }

    @Override
    public MinecraftConfig getMinecraftConfig() {
        return this.local.minecraft;
    }

    public static class ServerOverrideConfig
    implements ServerConfig {
        public final LocalConfig local = new LocalConfig();

        public ServerOverrideConfig(Config baseConfig, Config overrideConfig) {
            this.local.load(baseConfig);
            this.local.load(overrideConfig);
        }

        @Override
        public DiscordConfig getDiscordConfig() {
            return this.local.discord;
        }

        @Override
        public ChatConfig getChatConfig() {
            return this.local.discord.chat;
        }

        @Override
        public MinecraftConfig getMinecraftConfig() {
            return this.local.minecraft;
        }
    }
}

