/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord.config.definitions;

import java.util.Arrays;
import java.util.Optional;
import ooo.foooooooooooo.velocitydiscord.config.Config;
import ooo.foooooooooooo.velocitydiscord.config.definitions.ChannelTopicConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.ChatConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.UserMessageType;
import ooo.foooooooooooo.velocitydiscord.config.definitions.WebhookConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.commands.CommandConfig;
import ooo.foooooooooooo.velocitydiscord.discord.MessageCategory;

public class DiscordConfig {
    private static final String DEFAULT_CHANNEL_ID = "000000000000000000";
    public String mainChannelId = "000000000000000000";
    public boolean showBotMessages = false;
    public boolean showAttachmentsIngame = true;
    public boolean enableMentions = true;
    public boolean enableEveryoneAndHere = false;
    public int updateChannelTopicIntervalMinutes = 0;
    public ChatConfig chat = new ChatConfig();
    public CommandConfig commands = new CommandConfig();
    public ChannelTopicConfig channelTopic = new ChannelTopicConfig();
    public WebhookConfig webhook = new WebhookConfig();

    public void load(Config config) {
        if (config == null) {
            return;
        }
        this.mainChannelId = config.getOrDefault("channel", this.mainChannelId);
        this.showBotMessages = config.getOrDefault("show_bot_messages", this.showBotMessages);
        this.showAttachmentsIngame = config.getOrDefault("show_attachments_ingame", this.showAttachmentsIngame);
        this.enableMentions = config.getOrDefault("enable_mentions", this.enableMentions);
        this.enableEveryoneAndHere = config.getOrDefault("enable_everyone_and_here", this.enableEveryoneAndHere);
        this.updateChannelTopicIntervalMinutes = config.getOrDefault("update_channel_topic_interval", this.updateChannelTopicIntervalMinutes);
        this.chat.load(config.getConfig("chat"));
        this.commands.load(config.getConfig("commands"));
        this.channelTopic.load(config.getConfig("channel_topic"));
        this.webhook.load(config.getConfig("webhook"));
    }

    public boolean isWebhookUsed() {
        return Arrays.stream(new UserMessageType[]{this.chat.message.type, this.chat.death.type, this.chat.advancement.type, this.chat.join.type, this.chat.leave.type, this.chat.disconnect.type, this.chat.serverSwitch.type}).anyMatch(t -> t == UserMessageType.WEBHOOK);
    }

    public WebhookConfig getWebhookConfig(MessageCategory type) {
        Optional<WebhookConfig> messageSpecificWebhook = switch (type) {
            default -> throw new MatchException(null, null);
            case MessageCategory.ADVANCEMENT -> this.chat.advancement.webhook;
            case MessageCategory.MESSAGE -> this.chat.message.webhook;
            case MessageCategory.JOIN -> this.chat.join.webhook;
            case MessageCategory.DEATH -> this.chat.death.webhook;
            case MessageCategory.LEAVE -> this.chat.leave.webhook;
            case MessageCategory.DISCONNECT -> this.chat.disconnect.webhook;
            case MessageCategory.SERVER_SWITCH -> this.chat.serverSwitch.webhook;
        };
        return messageSpecificWebhook.orElse(this.webhook);
    }

    public boolean isDefaultChannel() {
        return this.mainChannelId.equals(DEFAULT_CHANNEL_ID);
    }
}

