/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord.config.definitions;

import java.util.ArrayList;
import ooo.foooooooooooo.velocitydiscord.config.Config;
import ooo.foooooooooooo.velocitydiscord.config.definitions.ChatConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.DiscordConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.MinecraftConfig;
import ooo.foooooooooooo.velocitydiscord.discord.MessageCategory;

public class LocalConfig {
    public DiscordConfig discord = new DiscordConfig();
    public MinecraftConfig minecraft = new MinecraftConfig();

    public void load(Config config) {
        this.discord.load(config.getConfig("discord"));
        this.minecraft.load(config.getConfig("minecraft"));
    }

    public String checkErrors() {
        if (this.discord.isWebhookUsed() && this.discord.webhook.isInvalid()) {
            ArrayList<MessageCategory> invalidCategories = new ArrayList<MessageCategory>();
            ChatConfig chat = this.discord.chat;
            if (chat.message.isInvalidWebhook()) {
                invalidCategories.add(MessageCategory.MESSAGE);
            }
            if (chat.join.isInvalidWebhook()) {
                invalidCategories.add(MessageCategory.JOIN);
            }
            if (chat.leave.isInvalidWebhook()) {
                invalidCategories.add(MessageCategory.LEAVE);
            }
            if (chat.disconnect.isInvalidWebhook()) {
                invalidCategories.add(MessageCategory.DISCONNECT);
            }
            if (chat.serverSwitch.isInvalidWebhook()) {
                invalidCategories.add(MessageCategory.SERVER_SWITCH);
            }
            if (chat.advancement.isInvalidWebhook()) {
                invalidCategories.add(MessageCategory.ADVANCEMENT);
            }
            if (chat.death.isInvalidWebhook()) {
                invalidCategories.add(MessageCategory.DEATH);
            }
            if (!invalidCategories.isEmpty()) {
                String errorFormat = "ERROR: `discord.webhook` and `discord.chat.%s.webhook` are unset or invalid, but `discord.chat.%s.type` is set to `webhook`";
                StringBuilder error = new StringBuilder();
                for (MessageCategory category : invalidCategories) {
                    error.append(String.format(errorFormat, new Object[]{category.toString(), category})).append("\n");
                }
                return error.toString();
            }
        }
        return null;
    }
}

