/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord.config.definitions;

import java.awt.Color;
import java.util.Optional;
import ooo.foooooooooooo.velocitydiscord.config.Config;
import ooo.foooooooooooo.velocitydiscord.config.definitions.UserMessageType;
import ooo.foooooooooooo.velocitydiscord.config.definitions.WebhookConfig;

public class UserMessageConfig {
    public UserMessageType type = UserMessageType.TEXT;
    public Optional<String> channelId = Optional.empty();
    public Optional<String> format;
    public Optional<Color> embedColor;
    public Optional<WebhookConfig> webhook = Optional.empty();

    public UserMessageConfig(String format, Color embedColor) {
        this.format = Optional.ofNullable(format);
        this.embedColor = Optional.ofNullable(embedColor);
    }

    public void load(Config config) {
        if (config == null) {
            return;
        }
        this.type = UserMessageType.get(config, "type", this.type);
        this.channelId = config.getDisableableStringOrDefault("channel", this.channelId);
        this.format = config.getDisableableStringOrDefault("format", this.format);
        this.embedColor = config.getDisableableColorOrDefault("embed_color", this.embedColor);
        Config webhookConfig = config.getConfig("webhook");
        if (webhookConfig == null) {
            this.webhook = Optional.empty();
        } else {
            this.webhook = Optional.of(new WebhookConfig());
            this.webhook.get().load(webhookConfig);
        }
    }

    public boolean isInvalidWebhook() {
        return this.type == UserMessageType.WEBHOOK && (this.webhook.isEmpty() || this.webhook.get().isInvalid());
    }
}

