/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord.config.definitions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ooo.foooooooooooo.velocitydiscord.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookConfig {
    private static final Logger logger = LoggerFactory.getLogger(WebhookConfig.class);
    private static final Pattern WEBHOOK_URL_REGEX = Pattern.compile("https?://(?:[^\\s.]+\\.)?discord(?:app)?\\.com/api(?:/v\\d+)?/webhooks/(?<id>\\d+)/(?<token>[^\\s/]+)", 2);
    public String url = "";
    public String avatarUrl = "https://visage.surgeplay.com/face/96/{uuid}";
    public String username = "{username}";
    public boolean valid = false;
    public String id;

    public void load(Config config) {
        if (config == null) {
            return;
        }
        this.url = config.getOrDefault("url", this.url);
        this.avatarUrl = config.getOrDefault("avatar_url", this.avatarUrl);
        this.username = config.getOrDefault("username", this.username);
        Matcher matcher = WEBHOOK_URL_REGEX.matcher(this.url);
        this.valid = matcher.matches();
        if (this.valid) {
            this.id = matcher.group("id");
        } else if (!this.url.isEmpty()) {
            logger.warn("Invalid webhook URL: {}", (Object)this.url);
        }
    }

    public boolean isInvalid() {
        return this.url.isEmpty() || !this.valid;
    }
}

