/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord.discord;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import java.awt.Color;
import java.lang.management.ManagementFactory;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import ooo.foooooooooooo.velocitydiscord.VelocityDiscord;
import ooo.foooooooooooo.velocitydiscord.config.ServerConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.ChatConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.DiscordConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.WebhookConfig;
import ooo.foooooooooooo.velocitydiscord.discord.MessageCategory;
import ooo.foooooooooooo.velocitydiscord.discord.MessageListener;
import ooo.foooooooooooo.velocitydiscord.discord.commands.ICommand;
import ooo.foooooooooooo.velocitydiscord.discord.commands.ListCommand;
import ooo.foooooooooooo.velocitydiscord.discord.message.IQueuedMessage;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.EmbedBuilder;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.JDA;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.JDABuilder;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.Activity;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.Guild;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.IncomingWebhookClient;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.Member;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.MessageEmbed;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.WebhookClient;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.events.session.ReadyEvent;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.hooks.ListenerAdapter;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.managers.channel.concrete.TextChannelManager;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.requests.GatewayIntent;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.utils.ChunkingFilter;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.utils.MemberCachePolicy;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.utils.messages.MessageCreateData;
import ooo.foooooooooooo.velocitydiscord.util.StringTemplate;

public class Discord
extends ListenerAdapter {
    private static final Pattern EveryoneAndHerePattern = Pattern.compile("@(?<ping>everyone|here)");
    private static final Pattern RawPingPattern = Pattern.compile("<@(?<ping>[!&]?\\d+)>");
    private final MessageListener messageListener;
    private final Map<String, ICommand> commands = new HashMap<String, ICommand>();
    private final HashMap<String, List<String>> mentionCompletions = new HashMap();
    private final HashMap<String, Channels> serverChannels = new HashMap();
    private final Queue<IQueuedMessage> preReadyQueue = new ArrayDeque<IQueuedMessage>();
    private boolean ready = false;
    private JDA jda;
    private String lastToken;
    private TextChannel mainChannel;
    private TextChannel proxyStartChannel;
    private TextChannel proxyStopChannel;
    private Channels defaultChannels;
    private int lastPlayerCount = -1;

    public Discord() {
        this.messageListener = new MessageListener(this.serverChannels);
        this.onConfigReload();
    }

    public void onConfigReload() {
        if (VelocityDiscord.CONFIG.global.discord.commands.list.enabled) {
            this.commands.put("list", new ListCommand());
        }
        if (!VelocityDiscord.CONFIG.global.discord.token.equals(this.lastToken)) {
            if (this.jda != null) {
                this.shutdown();
            }
            JDABuilder builder = JDABuilder.createDefault(VelocityDiscord.CONFIG.global.discord.token).setChunkingFilter(ChunkingFilter.ALL).enableIntents(GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT).setMemberCachePolicy(MemberCachePolicy.ALL).addEventListeners(this.messageListener, this);
            try {
                this.jda = builder.build();
                this.lastToken = VelocityDiscord.CONFIG.global.discord.token;
            }
            catch (Exception e) {
                VelocityDiscord.LOGGER.error("Failed to login to discord:", e);
            }
        } else {
            this.loadChannels();
        }
    }

    public void shutdown() {
        this.jda.shutdown();
    }

    @Override
    public void onReady(@Nonnull ReadyEvent event) {
        VelocityDiscord.LOGGER.info("Bot ready, Guilds: {} ({} available)", (Object)event.getGuildTotalCount(), (Object)event.getGuildAvailableCount());
        this.loadChannels();
        this.ready = true;
        for (IQueuedMessage msg : this.preReadyQueue) {
            msg.send(this);
        }
    }

    private void loadChannels() {
        String defaultChannelId = VelocityDiscord.CONFIG.local.discord.mainChannelId;
        this.mainChannel = this.loadChannel(defaultChannelId);
        this.proxyStartChannel = this.loadChannel(VelocityDiscord.CONFIG.global.discord.chat.proxyStart.channel.orElse(defaultChannelId));
        this.proxyStopChannel = this.loadChannel(VelocityDiscord.CONFIG.global.discord.chat.proxyStop.channel.orElse(defaultChannelId));
        this.serverChannels.clear();
        for (RegisteredServer server : VelocityDiscord.SERVER.getAllServers()) {
            String serverName = server.getServerInfo().getName();
            ServerConfig config = VelocityDiscord.CONFIG.getServerConfig(serverName);
            TextChannel defaultChannel = this.jda.getTextChannelById(config.getDiscordConfig().mainChannelId);
            this.serverChannels.put(serverName, new Channels(this, serverName, config, defaultChannel));
        }
        this.defaultChannels = new Channels(this, "default", VelocityDiscord.CONFIG, this.mainChannel);
        this.messageListener.onServerChannelsUpdated();
        this.mentionCompletions.clear();
        for (Channels channels : this.serverChannels.values()) {
            List<Member> members = channels.chatChannel.getMembers();
            this.mentionCompletions.put(channels.serverName, members.stream().map(m -> "@" + m.getUser().getName()).toList());
        }
        if (!this.commands.isEmpty()) {
            Guild guild = this.mainChannel.getGuild();
            for (Map.Entry<String, ICommand> entry : this.commands.entrySet()) {
                guild.upsertCommand(entry.getKey(), entry.getValue().description()).queue();
            }
        }
    }

    @Override
    public void onSlashCommandInteraction(@Nonnull SlashCommandInteractionEvent event) {
        if (!this.ready) {
            return;
        }
        String command = event.getName();
        if (!this.commands.containsKey(command)) {
            return;
        }
        this.commands.get(command).handle(event);
    }

    public void onPlayerChat(String username, String uuid, Optional<String> prefix, String server, String content) {
        ServerConfig serverConfig = VelocityDiscord.CONFIG.getServerConfig(server);
        DiscordConfig serverBotConfig = serverConfig.getDiscordConfig();
        ChatConfig serverDiscordConfig = serverConfig.getChatConfig();
        content = this.filterRawPings(content);
        if (serverBotConfig.enableMentions) {
            content = this.parseMentions(server, content);
        }
        if (!serverBotConfig.enableEveryoneAndHere) {
            content = this.filterEveryoneAndHere(content);
        }
        if (serverDiscordConfig.message.format.isPresent()) {
            String message = new StringTemplate(serverDiscordConfig.message.format.get()).add("username", username).add("server", VelocityDiscord.CONFIG.serverName(server)).add("message", content).add("prefix", prefix.orElse("")).toString();
            TextChannel targetChannel = this.getServerChannels((String)server).chatChannel;
            switch (serverDiscordConfig.message.type) {
                case EMBED: {
                    this.sendEmbedMessage(targetChannel, message, serverDiscordConfig.message.embedColor);
                    break;
                }
                case TEXT: {
                    this.sendMessage(targetChannel, message);
                    break;
                }
                case WEBHOOK: {
                    this.sendWebhookMessage(uuid, username, server, content, MessageCategory.MESSAGE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)serverDiscordConfig.message.type));
                }
            }
        }
    }

    private void sendChatCompletions(String server, Player player) {
        if (!this.ready) {
            this.preReadyQueue.add(new QueuedChatCompletion(server, player));
        } else {
            player.addCustomChatCompletions((Collection)this.mentionCompletions.get(server));
        }
    }

    public void onJoin(Player player, Optional<String> prefix, String server) {
        this.sendChatCompletions(server, player);
        ChatConfig serverDiscordConfig = VelocityDiscord.CONFIG.getServerConfig(server).getChatConfig();
        if (serverDiscordConfig.join.format.isEmpty()) {
            return;
        }
        String message = new StringTemplate(serverDiscordConfig.join.format.get()).add("username", player.getUsername()).add("server", VelocityDiscord.CONFIG.serverName(server)).add("prefix", prefix.orElse("")).toString();
        TextChannel targetChannel = this.getServerChannels((String)server).joinChannel;
        switch (serverDiscordConfig.join.type) {
            case EMBED: {
                this.sendEmbedMessage(targetChannel, message, serverDiscordConfig.join.embedColor);
                break;
            }
            case TEXT: {
                this.sendMessage(targetChannel, message);
                break;
            }
            case WEBHOOK: {
                this.sendWebhookMessage(player.getUniqueId().toString(), player.getUsername(), server, message, MessageCategory.JOIN);
            }
        }
    }

    public void onServerSwitch(String username, String uuid, Optional<String> prefix, String current, String previous) {
        ChatConfig serverDiscordConfig = VelocityDiscord.CONFIG.getServerConfig(current).getChatConfig();
        if (serverDiscordConfig.serverSwitch.format.isEmpty()) {
            return;
        }
        String message = new StringTemplate(serverDiscordConfig.serverSwitch.format.get()).add("username", username).add("current", VelocityDiscord.CONFIG.serverName(current)).add("previous", VelocityDiscord.CONFIG.serverName(previous)).add("prefix", prefix.orElse("")).toString();
        TextChannel targetChannel = this.getServerChannels((String)current).serverSwitchChannel;
        switch (serverDiscordConfig.serverSwitch.type) {
            case EMBED: {
                this.sendEmbedMessage(targetChannel, message, serverDiscordConfig.serverSwitch.embedColor);
                break;
            }
            case TEXT: {
                this.sendMessage(targetChannel, message);
                break;
            }
            case WEBHOOK: {
                this.sendWebhookMessage(uuid, username, current, message, MessageCategory.SERVER_SWITCH);
            }
        }
    }

    public void onDisconnect(String username, String uuid, Optional<String> prefix, String server) {
        ChatConfig serverDiscordConfig = VelocityDiscord.CONFIG.getServerConfig(server).getChatConfig();
        if (serverDiscordConfig.disconnect.format.isEmpty()) {
            return;
        }
        String message = new StringTemplate(serverDiscordConfig.disconnect.format.get()).add("username", username).add("prefix", prefix.orElse("")).toString();
        TextChannel targetChannel = this.getServerChannels((String)server).disconnectChannel;
        switch (serverDiscordConfig.disconnect.type) {
            case EMBED: {
                this.sendEmbedMessage(targetChannel, message, serverDiscordConfig.disconnect.embedColor);
                break;
            }
            case TEXT: {
                this.sendMessage(targetChannel, message);
                break;
            }
            case WEBHOOK: {
                this.sendWebhookMessage(uuid, username, server, message, MessageCategory.DISCONNECT);
            }
        }
    }

    public void onLeave(String username, String uuid, Optional<String> prefix, String server) {
        ChatConfig serverDiscordConfig = VelocityDiscord.CONFIG.getServerConfig(server).getChatConfig();
        if (serverDiscordConfig.leave.format.isEmpty()) {
            return;
        }
        String message = new StringTemplate(serverDiscordConfig.leave.format.get()).add("username", username).add("server", VelocityDiscord.CONFIG.serverName(server)).add("prefix", prefix.orElse("")).toString();
        TextChannel targetChannel = this.getServerChannels((String)server).leaveChannel;
        switch (serverDiscordConfig.leave.type) {
            case EMBED: {
                this.sendEmbedMessage(targetChannel, message, serverDiscordConfig.leave.embedColor);
                break;
            }
            case TEXT: {
                this.sendMessage(targetChannel, message);
                break;
            }
            case WEBHOOK: {
                this.sendWebhookMessage(uuid, username, server, message, MessageCategory.LEAVE);
            }
        }
    }

    public void onPlayerDeath(String username, String uuid, String server, String displayName, String death) {
        ChatConfig serverDiscordConfig = VelocityDiscord.CONFIG.getServerConfig(server).getChatConfig();
        if (serverDiscordConfig.death.format.isEmpty()) {
            return;
        }
        String message = new StringTemplate(serverDiscordConfig.death.format.get()).add("username", username).add("displayname", displayName).add("death_message", death).toString();
        TextChannel targetChannel = this.getServerChannels((String)server).deathChannel;
        switch (serverDiscordConfig.death.type) {
            case EMBED: {
                this.sendEmbedMessage(targetChannel, message, serverDiscordConfig.death.embedColor);
                break;
            }
            case TEXT: {
                this.sendMessage(targetChannel, message);
                break;
            }
            case WEBHOOK: {
                this.sendWebhookMessage(uuid, username, server, message, MessageCategory.DEATH);
            }
        }
    }

    public void onPlayerAdvancement(String username, String uuid, String server, String displayname, String title, String description) {
        ChatConfig serverDiscordConfig = VelocityDiscord.CONFIG.getServerConfig(server).getChatConfig();
        if (serverDiscordConfig.advancement.format.isEmpty()) {
            return;
        }
        String message = new StringTemplate(serverDiscordConfig.advancement.format.get()).add("username", username).add("displayname", displayname).add("advancement_title", title).add("advancement_description", description).toString();
        TextChannel targetChannel = this.getServerChannels((String)server).advancementChannel;
        switch (serverDiscordConfig.advancement.type) {
            case EMBED: {
                this.sendEmbedMessage(targetChannel, message, serverDiscordConfig.advancement.embedColor);
                break;
            }
            case TEXT: {
                this.sendMessage(targetChannel, message);
                break;
            }
            case WEBHOOK: {
                this.sendWebhookMessage(uuid, username, server, message, MessageCategory.ADVANCEMENT);
            }
        }
    }

    public void onProxyInitialize() {
        if (VelocityDiscord.CONFIG.global.discord.chat.proxyStart.format.isPresent()) {
            String message = VelocityDiscord.CONFIG.global.discord.chat.proxyStart.format.get();
            switch (VelocityDiscord.CONFIG.global.discord.chat.proxyStart.type) {
                case EMBED: {
                    this.sendEmbedMessage(this.proxyStartChannel, message, VelocityDiscord.CONFIG.global.discord.chat.proxyStart.embedColor);
                    break;
                }
                case TEXT: {
                    this.sendMessage(this.proxyStartChannel, message);
                }
            }
        }
    }

    public void onProxyShutdown() {
        if (VelocityDiscord.CONFIG.global.discord.chat.proxyStop.format.isPresent()) {
            String message = VelocityDiscord.CONFIG.global.discord.chat.proxyStop.format.get();
            switch (VelocityDiscord.CONFIG.global.discord.chat.proxyStop.type) {
                case EMBED: {
                    this.sendEmbedMessage(this.proxyStopChannel, message, VelocityDiscord.CONFIG.global.discord.chat.proxyStop.embedColor);
                    break;
                }
                case TEXT: {
                    this.sendMessage(this.proxyStopChannel, message);
                }
            }
        }
    }

    public void onServerStart(String server) {
        ChatConfig serverDiscordConfig = VelocityDiscord.CONFIG.getServerConfig(server).getChatConfig();
        if (serverDiscordConfig.serverStart.format.isPresent()) {
            String message = new StringTemplate(serverDiscordConfig.serverStart.format.get()).add("server", VelocityDiscord.CONFIG.serverName(server)).toString();
            TextChannel targetChannel = this.serverChannels.get((Object)server).serverStartChannel;
            switch (serverDiscordConfig.serverStart.type) {
                case EMBED: {
                    this.sendEmbedMessage(targetChannel, message, serverDiscordConfig.serverStart.embedColor);
                    break;
                }
                case TEXT: {
                    this.sendMessage(targetChannel, message);
                }
            }
        }
    }

    public void onServerStop(String server) {
        ChatConfig serverDiscordConfig = VelocityDiscord.CONFIG.getServerConfig(server).getChatConfig();
        if (serverDiscordConfig.serverStop.format.isPresent()) {
            String message = new StringTemplate(serverDiscordConfig.serverStop.format.get()).add("server", VelocityDiscord.CONFIG.serverName(server)).toString();
            TextChannel targetChannel = this.serverChannels.get((Object)server).serverStopChannel;
            switch (serverDiscordConfig.serverStop.type) {
                case EMBED: {
                    this.sendEmbedMessage(targetChannel, message, serverDiscordConfig.serverStop.embedColor);
                    break;
                }
                case TEXT: {
                    this.sendMessage(targetChannel, message);
                }
            }
        }
    }

    public void updateActivityPlayerAmount(int count) {
        if (VelocityDiscord.CONFIG.global.discord.activityText.isEmpty() || !this.ready) {
            return;
        }
        if (this.lastPlayerCount != count) {
            String message = new StringTemplate(VelocityDiscord.CONFIG.global.discord.activityText.get()).add("amount", count).toString();
            this.jda.getPresence().setActivity(Activity.playing(message));
            this.lastPlayerCount = count;
        }
    }

    public String generateChannelTopic() {
        DiscordConfig config = VelocityDiscord.CONFIG.local.discord;
        if (config.channelTopic.format.isEmpty()) {
            return null;
        }
        int playerCount = VelocityDiscord.SERVER.getPlayerCount();
        Object playerList = "";
        if (config.channelTopic.format.get().contains("{player_list}")) {
            String players = VelocityDiscord.SERVER.getAllPlayers().stream().limit(config.channelTopic.playerListMaxCount).map(player -> new StringTemplate(config.channelTopic.playerListPlayerFormat).add("username", player.getUsername()).add("ping", player.getPing()).toString()).reduce("", (a, b) -> a + config.channelTopic.playerListSeparator + b);
            if (!players.isEmpty()) {
                players = players.substring(config.channelTopic.playerListSeparator.length());
                playerList = config.channelTopic.playerListHeader.isPresent() ? config.channelTopic.playerListHeader.get() + players : players;
            } else {
                playerList = config.channelTopic.playerListNoPlayersHeader.orElse("");
            }
        }
        ProxyServer s = VelocityDiscord.SERVER;
        int serverCount = s.getAllServers().size();
        List<String> serverList = s.getAllServers().stream().map(registeredServer -> registeredServer.getServerInfo().getName()).toList();
        String hostname = s.getBoundAddress().getHostName();
        String port = String.valueOf(s.getBoundAddress().getPort());
        String queryMotd = PlainTextComponentSerializer.plainText().serialize(s.getConfiguration().getMotd());
        int queryPort = s.getConfiguration().getQueryPort();
        int queryMaxPlayers = s.getConfiguration().getShowMaxPlayers();
        int pluginCount = s.getPluginManager().getPlugins().size();
        List pluginList = s.getPluginManager().getPlugins().stream().map(plugin -> plugin.getDescription().getName()).flatMap(Optional::stream).toList();
        String proxyVersion = s.getVersion().getVersion();
        String proxySoftware = s.getVersion().getName();
        double averagePing = s.getAllPlayers().stream().mapToLong(Player::getPing).average().orElse(0.0);
        long uptimeMillis = ManagementFactory.getRuntimeMXBean().getUptime();
        String formattedUptime = this.formatUptime(uptimeMillis);
        HashMap<String, String> serverStatuses = new HashMap<String, String>();
        for (RegisteredServer registeredServer2 : s.getAllServers()) {
            String name = registeredServer2.getServerInfo().getName();
            if (VelocityDiscord.CONFIG.serverDisabled(name)) continue;
            DiscordConfig discordConfig = VelocityDiscord.CONFIG.getServerConfig(name).getDiscordConfig();
            if (discordConfig.channelTopic.serverFormat.isEmpty()) {
                serverStatuses.put(name, "");
            }
            try {
                CompletableFuture ping = registeredServer2.ping();
                ((CompletableFuture)ping.thenAccept(serverPing -> {
                    if (serverPing.getPlayers().isEmpty()) {
                        return;
                    }
                    ServerPing.Players players = (ServerPing.Players)serverPing.getPlayers().get();
                    int online = players.getOnline();
                    int max = players.getMax();
                    String ver = serverPing.getVersion().getName();
                    int protocol = serverPing.getVersion().getProtocol();
                    String motd = PlainTextComponentSerializer.plainText().serialize(serverPing.getDescriptionComponent());
                    String serverStatus = new StringTemplate(serverDiscordConfig.channelTopic.serverFormat.get()).add("name", VelocityDiscord.CONFIG.serverName(name)).add("players", online).add("max_players", max).add("version", ver).add("protocol", protocol).add("motd", motd).toString();
                    serverStatuses.put(name, serverStatus);
                })).get(5L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (discordConfig.channelTopic.serverOfflineFormat.isEmpty()) {
                    serverStatuses.put(name, "");
                    continue;
                }
                String serverStatus = new StringTemplate(discordConfig.channelTopic.serverOfflineFormat.get()).add("name", VelocityDiscord.CONFIG.serverName(name)).toString();
                serverStatuses.put(name, serverStatus);
            }
        }
        DiscordConfig serverDiscordConfig = VelocityDiscord.CONFIG.local.discord;
        if (serverDiscordConfig.channelTopic.format.isEmpty()) {
            return "";
        }
        StringTemplate template = new StringTemplate(serverDiscordConfig.channelTopic.format.get()).add("players", playerCount).add("player_list", (String)playerList).add("servers", serverCount).add("server_list", String.join((CharSequence)", ", serverList.stream().map(VelocityDiscord.CONFIG::serverName).toList())).add("hostname", hostname).add("port", port).add("motd", queryMotd).add("query_port", queryPort).add("max_players", queryMaxPlayers).add("plugins", pluginCount).add("plugin_list", String.join((CharSequence)", ", pluginList)).add("version", proxyVersion).add("software", proxySoftware).add("average_ping", String.format("%.2f ms", averagePing)).add("uptime", formattedUptime);
        for (Map.Entry entry : serverStatuses.entrySet()) {
            template.add("server[" + (String)entry.getKey() + "]", (String)entry.getValue());
        }
        Object topic = template.toString();
        if (((String)topic).length() > 1024) {
            topic = ((String)topic).substring(0, 1000) + "...";
        }
        return topic;
    }

    public void updateChannelTopic() {
        if (!this.ready) {
            return;
        }
        String topic = this.generateChannelTopic();
        if (topic == null) {
            return;
        }
        ((TextChannelManager)this.mainChannel.getManager().setTopic(topic)).queue();
    }

    private String formatUptime(long uptimeMillis) {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(uptimeMillis);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(uptimeMillis);
        long hours = TimeUnit.MILLISECONDS.toHours(uptimeMillis);
        long days = TimeUnit.MILLISECONDS.toDays(uptimeMillis);
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (minutes < 60L) {
            long remainingSeconds = seconds % 60L;
            return minutes + "m " + remainingSeconds + "s";
        }
        if (hours < 24L) {
            long remainingMinutes = minutes % 60L;
            return hours + "h " + remainingMinutes + "m";
        }
        if (days < 7L) {
            long remainingHours = hours % 24L;
            return days + "d " + remainingHours + "h";
        }
        long weeks = days / 7L;
        long remainingDays = days % 7L;
        return weeks + "w " + remainingDays + "d";
    }

    private void sendMessage(TextChannel targetChannel, @Nonnull String message) {
        if (this.ready) {
            targetChannel.sendMessage(message).queue();
        } else {
            this.preReadyQueue.add(new QueuedStringMessage(targetChannel, message));
        }
    }

    private void sendEmbedMessage(TextChannel channel, String message, Optional<Color> color) {
        EmbedBuilder embed = new EmbedBuilder().setDescription(message);
        color.ifPresent(embed::setColor);
        if (this.ready) {
            channel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
        } else {
            this.preReadyQueue.add(new QueuedEmbedMessage(channel, embed));
        }
    }

    private void sendWebhookMessage(String uuid, String username, String server, String content, MessageCategory type) {
        ServerConfig serverConfig = VelocityDiscord.CONFIG.getServerConfig(server);
        WebhookConfig webhookConfig = serverConfig.getDiscordConfig().getWebhookConfig(type);
        String avatar = new StringTemplate(webhookConfig.avatarUrl).add("username", username).add("uuid", uuid).toString();
        String discordName = new StringTemplate(webhookConfig.username).add("username", username).add("server", VelocityDiscord.CONFIG.serverName(server)).toString();
        MessageCreateData webhookMessage = ((MessageCreateBuilder)new MessageCreateBuilder().setContent(content)).build();
        if (this.ready) {
            Channels channels = this.serverChannels.get(server);
            if (channels == null) {
                VelocityDiscord.LOGGER.error("Failed to get webhook client for server `{}`: serverChannels is null", (Object)server);
                return;
            }
            IncomingWebhookClient client = channels.getClientForCategory(type);
            if (client == null) {
                VelocityDiscord.LOGGER.error("Failed to get webhook client for server `{}`: client is null", (Object)server);
                return;
            }
            VelocityDiscord.LOGGER.info("Sending webhook message to `{}`: avatar={}, username={}", server, avatar, discordName);
            client.sendMessage(webhookMessage).setAvatarUrl(avatar).setUsername(discordName).queue();
        } else {
            this.preReadyQueue.add(new QueuedWebhookMessage(server, type, webhookMessage, avatar, discordName));
        }
    }

    private String parseMentions(String server, String message) {
        Channels channels = this.serverChannels.get(server);
        if (channels == null || channels.chatChannel == null || !this.ready) {
            return message;
        }
        String msg = message;
        for (Member member : channels.chatChannel.getMembers()) {
            msg = Pattern.compile(Pattern.quote("@" + member.getUser().getName()), 2).matcher(msg).replaceAll(member.getAsMention());
        }
        return msg;
    }

    private String filterEveryoneAndHere(String message) {
        return EveryoneAndHerePattern.matcher(message).replaceAll("@\u200b${ping}");
    }

    private String filterRawPings(String message) {
        return RawPingPattern.matcher(message).replaceAll("<@\u200b${ping}>");
    }

    private TextChannel loadChannel(String id) {
        TextChannel channel = this.jda.getTextChannelById(id);
        if (channel == null) {
            VelocityDiscord.LOGGER.error("Could not load channel with id: {}", (Object)id);
            return null;
        }
        if (!channel.canTalk()) {
            VelocityDiscord.LOGGER.error("Cannot talk in configured channel");
            return null;
        }
        return channel;
    }

    private Channels getServerChannels(String server) {
        return this.serverChannels.getOrDefault(server, this.defaultChannels);
    }

    public static class Channels {
        public String serverName;
        private IncomingWebhookClient mainWebhook;
        public TextChannel chatChannel;
        public IncomingWebhookClient chatWebhook;
        public TextChannel deathChannel;
        public IncomingWebhookClient deathWebhook;
        public TextChannel advancementChannel;
        public IncomingWebhookClient advancementWebhook;
        public TextChannel joinChannel;
        public IncomingWebhookClient joinWebhook;
        public TextChannel leaveChannel;
        public IncomingWebhookClient leaveWebhook;
        public TextChannel disconnectChannel;
        public IncomingWebhookClient disconnectWebhook;
        public TextChannel serverSwitchChannel;
        public IncomingWebhookClient serverSwitchWebhook;
        public TextChannel serverStartChannel;
        public TextChannel serverStopChannel;

        public Channels(Discord discord, String serverName, ServerConfig config, TextChannel defaultChannel) {
            this.serverName = serverName;
            ChatConfig chat = config.getDiscordConfig().chat;
            this.chatChannel = Channels.getChannel(discord, chat.message.channelId, defaultChannel);
            this.deathChannel = Channels.getChannel(discord, chat.death.channelId, defaultChannel);
            this.advancementChannel = Channels.getChannel(discord, chat.advancement.channelId, defaultChannel);
            this.joinChannel = Channels.getChannel(discord, chat.join.channelId, defaultChannel);
            this.leaveChannel = Channels.getChannel(discord, chat.leave.channelId, defaultChannel);
            this.disconnectChannel = Channels.getChannel(discord, chat.disconnect.channelId, defaultChannel);
            this.serverSwitchChannel = Channels.getChannel(discord, chat.serverSwitch.channelId, defaultChannel);
            this.serverStartChannel = Channels.getChannel(discord, chat.serverStart.channel, defaultChannel);
            this.serverStopChannel = Channels.getChannel(discord, chat.serverStop.channel, defaultChannel);
            this.mainWebhook = null;
            if (config.getDiscordConfig().isWebhookUsed()) {
                this.chatWebhook = this.getClient(discord, chat.message.webhook);
                this.deathWebhook = this.getClient(discord, chat.death.webhook);
                this.advancementWebhook = this.getClient(discord, chat.advancement.webhook);
                this.joinWebhook = this.getClient(discord, chat.join.webhook);
                this.leaveWebhook = this.getClient(discord, chat.leave.webhook);
                this.disconnectWebhook = this.getClient(discord, chat.disconnect.webhook);
                this.serverSwitchWebhook = this.getClient(discord, chat.serverSwitch.webhook);
            }
        }

        public IncomingWebhookClient getClientForCategory(MessageCategory category) {
            return switch (category) {
                default -> throw new MatchException(null, null);
                case MessageCategory.MESSAGE -> this.chatWebhook;
                case MessageCategory.DEATH -> this.deathWebhook;
                case MessageCategory.ADVANCEMENT -> this.advancementWebhook;
                case MessageCategory.JOIN -> this.joinWebhook;
                case MessageCategory.LEAVE -> this.leaveWebhook;
                case MessageCategory.DISCONNECT -> this.disconnectWebhook;
                case MessageCategory.SERVER_SWITCH -> this.serverSwitchWebhook;
            };
        }

        private static TextChannel getChannel(Discord discord, Optional<String> id, TextChannel defaultChannel) {
            if (id.isEmpty()) {
                return defaultChannel;
            }
            return discord.loadChannel(id.get());
        }

        private IncomingWebhookClient createClient(Discord discord, WebhookConfig config) {
            try {
                return WebhookClient.createClient(discord.jda, config.url);
            }
            catch (Exception e) {
                VelocityDiscord.LOGGER.error("Failed to create webhook client for server {}", (Object)this.serverName, (Object)e);
                return null;
            }
        }

        private IncomingWebhookClient getMainWebhook(Discord discord) {
            WebhookConfig config;
            if (this.mainWebhook == null && !(config = VelocityDiscord.CONFIG.getServerConfig((String)this.serverName).getDiscordConfig().webhook).isInvalid()) {
                this.mainWebhook = this.createClient(discord, config);
            }
            return this.mainWebhook;
        }

        private IncomingWebhookClient getClient(Discord discord, Optional<WebhookConfig> config) {
            if (config.isEmpty() || config.get().isInvalid()) {
                return this.getMainWebhook(discord);
            }
            return this.createClient(discord, config.get());
        }
    }

    private record QueuedChatCompletion(String server, Player player) implements IQueuedMessage
    {
        @Override
        public void send(Discord discord) {
            this.player.addCustomChatCompletions((Collection)discord.mentionCompletions.get(this.server));
        }
    }

    private record QueuedStringMessage(TextChannel channel, String message) implements IQueuedMessage
    {
        @Override
        public void send(Discord discord) {
            this.channel.sendMessage(this.message).queue();
        }
    }

    private record QueuedEmbedMessage(TextChannel channel, EmbedBuilder embed) implements IQueuedMessage
    {
        @Override
        public void send(Discord discord) {
            this.channel.sendMessageEmbeds(this.embed.build(), new MessageEmbed[0]).queue();
        }
    }

    private record QueuedWebhookMessage(String server, MessageCategory type, MessageCreateData message, String avatar, String username) implements IQueuedMessage
    {
        @Override
        public void send(Discord discord) {
            Channels channels = discord.serverChannels.get(this.server);
            if (channels == null) {
                VelocityDiscord.LOGGER.error("[Queued] Failed to get webhook client for server `{}`: serverChannels is null", (Object)this.server);
                return;
            }
            IncomingWebhookClient client = channels.getClientForCategory(this.type);
            if (client != null) {
                client.sendMessage(this.message).setAvatarUrl(this.avatar).setUsername(this.username).queue();
            } else {
                VelocityDiscord.LOGGER.error("[Queued] Failed to get webhook client for server `{}`: client is null", (Object)this.server);
            }
        }
    }
}

