/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord.discord;

import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.awt.Color;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.kyori.adventure.text.minimessage.MiniMessage;
import ooo.foooooooooooo.velocitydiscord.VelocityDiscord;
import ooo.foooooooooooo.velocitydiscord.config.ServerConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.DiscordConfig;
import ooo.foooooooooooo.velocitydiscord.config.definitions.MinecraftConfig;
import ooo.foooooooooooo.velocitydiscord.discord.Discord;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.JDA;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.Guild;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.Member;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.Message;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.Role;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.User;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.channel.ChannelType;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.hooks.ListenerAdapter;
import ooo.foooooooooooo.velocitydiscord.util.StringTemplate;

public class MessageListener
extends ListenerAdapter {
    private static final Pattern LINK_REGEX = Pattern.compile("[hH][tT]{2}[pP][sS]?://([a-zA-Z0-9\\u00a1-\\uffff]+(:[a-zA-Z0-9\\u00a1-\\uffff]+)?@)?[a-zA-Z0-9\\u00a1-\\uffff][a-zA-Z0-9\\u00a1-\\uffff_-]{0,62}(?:\\.[a-zA-Z0-9\\u00a1-\\uffff_-]{1,62})*(?::\\d{1,5})?(?:/[a-zA-Z0-9\\u00a1-\\uffff_\\-().]*)*(?:[?#][a-zA-Z0-9\\u00a1-\\uffff_\\-()?/=&#%.*]*)?");
    private final HashMap<String, Discord.Channels> serverChannels;
    private final HashMap<Long, List<String>> channelToServersMap = new HashMap();
    private JDA jda;
    private static final Set<String> SUPPORTED_URI_PROTOCOLS = Set.of("http", "https");

    public MessageListener(HashMap<String, Discord.Channels> serverChannels) {
        this.serverChannels = serverChannels;
        this.onServerChannelsUpdated();
    }

    public void onServerChannelsUpdated() {
        this.channelToServersMap.clear();
        for (Map.Entry<String, Discord.Channels> entry : this.serverChannels.entrySet()) {
            this.channelToServersMap.computeIfAbsent(entry.getValue().chatChannel.getIdLong(), k -> new ArrayList()).add(entry.getKey());
        }
    }

    @Override
    public void onMessageReceived(@Nonnull MessageReceivedEvent event) {
        TextChannel channel;
        List<String> targetServerNames;
        if (!event.isFromType(ChannelType.TEXT)) {
            VelocityDiscord.LOGGER.trace("ignoring non text channel message");
            return;
        }
        if (this.jda == null) {
            this.jda = event.getJDA();
        }
        if ((targetServerNames = this.channelToServersMap.get((channel = event.getChannel().asTextChannel()).getIdLong())) == null) {
            return;
        }
        VelocityDiscord.LOGGER.trace("Received message from Discord channel {} for servers {}", (Object)channel.getName(), (Object)targetServerNames);
        HashMap<String, String> messages = new HashMap<String, String>();
        for (String serverName : targetServerNames) {
            messages.put(serverName, this.serializeMinecraftMessage(event, serverName));
        }
        for (RegisteredServer server : VelocityDiscord.SERVER.getAllServers()) {
            String message;
            String serverName = server.getServerInfo().getName();
            if (!VelocityDiscord.CONFIG.global.excludedServersReceiveMessages && VelocityDiscord.CONFIG.serverDisabled(serverName) || (message = (String)messages.get(serverName)) == null) continue;
            server.sendMessage(MiniMessage.miniMessage().deserialize((Object)message).asComponent());
        }
    }

    private String serializeMinecraftMessage(MessageReceivedEvent event, String server) {
        ServerConfig serverConfig = VelocityDiscord.CONFIG.getServerConfig(server);
        MinecraftConfig serverMinecraftConfig = serverConfig.getMinecraftConfig();
        DiscordConfig serverDiscordConfig = serverConfig.getDiscordConfig();
        User author = event.getAuthor();
        if (!serverDiscordConfig.showBotMessages && author.isBot()) {
            VelocityDiscord.LOGGER.debug("ignoring bot message");
            return null;
        }
        if (author.getId().equals(this.jda.getSelfUser().getId()) || author.getId().equals(serverDiscordConfig.webhook.id)) {
            VelocityDiscord.LOGGER.debug("ignoring own message");
            return null;
        }
        Message message = event.getMessage();
        Guild guild = event.getGuild();
        Color color = Color.white;
        String nickname = author.getName();
        String rolePrefix = "";
        Member member = guild.getMember(author);
        if (member != null) {
            color = member.getColor();
            if (color == null) {
                color = Color.white;
            }
            nickname = member.getEffectiveName();
            Optional<Role> highestRole = member.getRoles().stream().filter(role -> !serverMinecraftConfig.getRolePrefix(role.getId()).isEmpty()).findFirst();
            rolePrefix = highestRole.map(role -> serverMinecraftConfig.getRolePrefix(role.getId())).orElse("");
        }
        String hex = "#" + Integer.toHexString(color.getRGB()).substring(2);
        String discord_chunk = new StringTemplate(serverMinecraftConfig.discordChunkFormat).add("discord_color", serverMinecraftConfig.discordColor).toString();
        String display_name = author.getGlobalName();
        if (display_name == null) {
            display_name = author.getName();
        }
        String username_chunk = new StringTemplate(serverMinecraftConfig.usernameChunkFormat).add("role_color", hex).add("username", this.escapeTags(author.getName())).add("display_name", this.escapeTags(display_name)).add("nickname", this.escapeTags(nickname)).toString();
        String attachment_chunk = serverMinecraftConfig.attachmentFormat;
        StringTemplate message_chunk = new StringTemplate(serverMinecraftConfig.messageFormat).add("discord_chunk", discord_chunk).add("role_prefix", this.escapeTags(rolePrefix)).add("username_chunk", username_chunk).add("message", message.getContentDisplay());
        ArrayList<String> attachmentChunks = new ArrayList<String>();
        List<Object> attachments = new ArrayList();
        if (serverDiscordConfig.showAttachmentsIngame) {
            attachments = message.getAttachments();
        }
        for (Message.Attachment attachment : attachments) {
            String chunk = new StringTemplate(attachment_chunk).add("url", attachment.getUrl()).add("attachment_color", serverMinecraftConfig.attachmentColor).toString();
            attachmentChunks.add(chunk);
        }
        String content = message.getContentDisplay();
        if (content.isBlank()) {
            message_chunk = message_chunk.replace(" {attachments}", "{attachments}");
        }
        if (serverMinecraftConfig.linkFormat.isPresent()) {
            content = LINK_REGEX.matcher(content).replaceAll(match -> {
                String url = match.group();
                if (this.validateUrl(url)) {
                    String replacement = new StringTemplate(serverMinecraftConfig.linkFormat.get()).add("url", url).add("link_color", serverMinecraftConfig.linkColor).toString();
                    return Matcher.quoteReplacement(replacement);
                }
                return Matcher.quoteReplacement(url);
            });
        }
        message_chunk.add("message", content);
        message_chunk.add("attachments", String.join((CharSequence)" ", attachmentChunks));
        return message_chunk.toString();
    }

    private boolean validateUrl(String url) {
        try {
            return SUPPORTED_URI_PROTOCOLS.contains(new URI(url).getScheme().toLowerCase(Locale.ROOT));
        }
        catch (Exception e) {
            return false;
        }
    }

    private String escapeTags(String input) {
        return input.replace("<", "\u2039").replace(">", "\u203a");
    }
}

