/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord.discord.commands;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Collection;
import ooo.foooooooooooo.velocitydiscord.VelocityDiscord;
import ooo.foooooooooooo.velocitydiscord.VelocityListener;
import ooo.foooooooooooo.velocitydiscord.config.definitions.DiscordConfig;
import ooo.foooooooooooo.velocitydiscord.discord.commands.ICommand;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.interactions.commands.SlashCommandInteraction;
import ooo.foooooooooooo.velocitydiscord.util.StringTemplate;

public class ListCommand
implements ICommand {
    public static final String COMMAND_NAME = "list";

    @Override
    public void handle(SlashCommandInteraction interaction) {
        Collection servers = VelocityDiscord.SERVER.getAllServers();
        StringBuilder sb = new StringBuilder();
        sb.append("```").append(VelocityDiscord.CONFIG.global.discord.commands.list.codeblockLang).append('\n');
        for (RegisteredServer server : servers) {
            String name = server.getServerInfo().getName();
            if (VelocityDiscord.CONFIG.serverDisabled(name)) continue;
            DiscordConfig serverDiscordConfig = VelocityDiscord.CONFIG.getServerConfig(name).getDiscordConfig();
            Collection players = server.getPlayersConnected();
            VelocityListener.ServerState state = VelocityDiscord.getListener().getServerState(server);
            String serverInfo = new StringTemplate(serverDiscordConfig.commands.list.serverFormat).add("server_name", VelocityDiscord.CONFIG.serverName(name)).add("online_players", state.players).add("max_players", state.maxPlayers).toString();
            sb.append(serverInfo).append('\n');
            if (!state.online && serverDiscordConfig.commands.list.serverOfflineFormat.isPresent()) {
                sb.append(serverDiscordConfig.commands.list.serverOfflineFormat.get()).append('\n');
            } else if (state.players == 0 && serverDiscordConfig.commands.list.noPlayersFormat.isPresent()) {
                sb.append(serverDiscordConfig.commands.list.noPlayersFormat.get()).append('\n');
            } else {
                for (Player player : players) {
                    String user = new StringTemplate(serverDiscordConfig.commands.list.playerFormat).add("username", player.getUsername()).toString();
                    sb.append(user).append('\n');
                }
            }
            sb.append('\n');
        }
        sb.append("```");
        interaction.reply(sb.toString()).setEphemeral(VelocityDiscord.CONFIG.global.discord.commands.list.ephemeral).queue();
    }

    @Override
    public String description() {
        return "List all servers and their players";
    }
}

