/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.automod.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.automod.AutoModTriggerType;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.automod.build.AbstractTriggerConfig;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.utils.data.DataArray;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.utils.data.DataObject;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.internal.utils.Checks;

public abstract class AbstractKeywordTriggerConfig<B extends AbstractKeywordTriggerConfig<B>>
extends AbstractTriggerConfig<B> {
    protected final List<String> allowList = new ArrayList<String>();

    protected AbstractKeywordTriggerConfig(AutoModTriggerType triggerType) {
        super(triggerType);
    }

    @Nonnull
    public B addAllowList(String ... keywords) {
        Checks.noneNull(keywords, "Keywords");
        Checks.check(this.allowList.size() + keywords.length <= this.maxAllowListAmount(), "Cannot add more than %d keywords!", (Object)this.maxAllowListAmount());
        Arrays.stream(keywords).forEach(AbstractKeywordTriggerConfig::checkKeyword);
        Collections.addAll(this.allowList, keywords);
        return (B)this;
    }

    @Nonnull
    public B addAllowList(@Nonnull Collection<String> keywords) {
        Checks.noneNull(keywords, "Keywords");
        Checks.check(this.allowList.size() + keywords.size() <= this.maxAllowListAmount(), "Cannot add more than %d keywords!", (Object)this.maxAllowListAmount());
        keywords.forEach(AbstractKeywordTriggerConfig::checkKeyword);
        this.allowList.addAll(keywords);
        return (B)this;
    }

    @Nonnull
    public B setAllowList(@Nonnull Collection<String> keywords) {
        Checks.noneNull(keywords, "Keywords");
        Checks.check(keywords.size() <= this.maxAllowListAmount(), "Cannot add more than %d keywords!", (Object)this.maxAllowListAmount());
        keywords.forEach(AbstractKeywordTriggerConfig::checkKeyword);
        this.allowList.clear();
        this.allowList.addAll(keywords);
        return (B)this;
    }

    protected abstract int maxAllowListAmount();

    protected static void checkKeyword(String keyword) {
        Checks.notEmpty(keyword, "Keyword");
        Checks.notLonger(keyword, 60, "Keyword");
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject data = super.toData();
        data.put("allow_list", DataArray.fromCollection(this.allowList));
        return data;
    }
}

