/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.automod.build;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.automod.AutoModTriggerType;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.automod.build.AbstractKeywordTriggerConfig;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.utils.data.DataArray;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.utils.data.DataObject;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.internal.utils.Checks;

public class CustomKeywordTriggerConfig
extends AbstractKeywordTriggerConfig<CustomKeywordTriggerConfig> {
    protected final Set<String> keywords = new HashSet<String>();
    protected final Set<String> patterns = new HashSet<String>();

    protected CustomKeywordTriggerConfig() {
        super(AutoModTriggerType.KEYWORD);
    }

    @Nonnull
    public CustomKeywordTriggerConfig addKeywords(String ... keywords) {
        Checks.noneNull(keywords, "Keywords");
        Checks.check(this.keywords.size() + keywords.length <= 1000, "Cannot add more than %d keywords!", (Object)1000);
        for (String keyword : keywords) {
            CustomKeywordTriggerConfig.checkKeyword(keyword);
        }
        Collections.addAll(this.keywords, keywords);
        return this;
    }

    @Nonnull
    public CustomKeywordTriggerConfig addKeywords(@Nonnull Collection<String> keywords) {
        Checks.noneNull(keywords, "Keywords");
        Checks.check(this.keywords.size() + keywords.size() <= 1000, "Cannot add more than %d keywords!", (Object)1000);
        for (String keyword : keywords) {
            CustomKeywordTriggerConfig.checkKeyword(keyword);
        }
        this.keywords.addAll(keywords);
        return this;
    }

    @Nonnull
    public CustomKeywordTriggerConfig setKeywords(@Nonnull Collection<String> keywords) {
        Checks.noneNull(keywords, "Keywords");
        Checks.check(keywords.size() <= 1000, "Cannot add more than %d keywords!", (Object)1000);
        for (String keyword : keywords) {
            CustomKeywordTriggerConfig.checkKeyword(keyword);
        }
        this.keywords.clear();
        this.keywords.addAll(keywords);
        return this;
    }

    @Nonnull
    public CustomKeywordTriggerConfig addPatterns(String ... patterns) {
        Checks.noneNull(patterns, "Patterns");
        Checks.check(this.patterns.size() + patterns.length <= 10, "Cannot add more than %d patterns!", (Object)10);
        for (String pattern : patterns) {
            CustomKeywordTriggerConfig.checkPattern(pattern);
        }
        Collections.addAll(this.patterns, patterns);
        return this;
    }

    @Nonnull
    public CustomKeywordTriggerConfig addPatterns(@Nonnull Collection<String> patterns) {
        Checks.noneNull(patterns, "Patterns");
        Checks.check(this.patterns.size() + patterns.size() <= 10, "Cannot add more than %d patterns!", (Object)10);
        for (String pattern : patterns) {
            CustomKeywordTriggerConfig.checkPattern(pattern);
        }
        this.patterns.addAll(patterns);
        return this;
    }

    @Nonnull
    public CustomKeywordTriggerConfig setPatterns(@Nonnull Collection<String> patterns) {
        Checks.noneNull(patterns, "Patterns");
        Checks.check(patterns.size() <= 10, "Cannot add more than %d patterns!", (Object)10);
        for (String pattern : patterns) {
            CustomKeywordTriggerConfig.checkPattern(pattern);
        }
        this.patterns.clear();
        this.patterns.addAll(patterns);
        return this;
    }

    protected static void checkPattern(String pattern) {
        Checks.notBlank(pattern, "Pattern");
        Checks.notLonger(pattern, 260, "Pattern");
    }

    @Override
    protected int maxAllowListAmount() {
        return 100;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        Checks.check(!this.keywords.isEmpty() || !this.patterns.isEmpty(), "Must have at least one keyword or pattern!");
        DataObject data = super.toData();
        data.put("keyword_filter", DataArray.fromCollection(this.keywords));
        data.put("regex_patterns", DataArray.fromCollection(this.patterns));
        return data;
    }
}

