/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.interactions.commands.build;

import java.util.Map;
import javax.annotation.Nonnull;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.interactions.DiscordLocale;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.interactions.commands.Command;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.interactions.commands.localization.LocalizationFunction;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.interactions.commands.localization.LocalizationMap;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.utils.data.DataObject;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.utils.data.SerializableData;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.internal.interactions.CommandDataImpl;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.internal.utils.Checks;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.internal.utils.localization.LocalizationUtils;

public interface CommandData
extends SerializableData {
    public static final int MAX_NAME_LENGTH = 32;
    public static final int MAX_DESCRIPTION_LENGTH = 100;
    public static final int MAX_OPTIONS = 25;

    @Nonnull
    public CommandData setLocalizationFunction(@Nonnull LocalizationFunction var1);

    @Nonnull
    public CommandData setName(@Nonnull String var1);

    @Nonnull
    public CommandData setNameLocalization(@Nonnull DiscordLocale var1, @Nonnull String var2);

    @Nonnull
    public CommandData setNameLocalizations(@Nonnull Map<DiscordLocale, String> var1);

    @Nonnull
    public CommandData setDefaultPermissions(@Nonnull DefaultMemberPermissions var1);

    @Nonnull
    public CommandData setGuildOnly(boolean var1);

    @Nonnull
    public CommandData setNSFW(boolean var1);

    @Nonnull
    public String getName();

    @Nonnull
    public LocalizationMap getNameLocalizations();

    @Nonnull
    public Command.Type getType();

    @Nonnull
    public DefaultMemberPermissions getDefaultPermissions();

    public boolean isGuildOnly();

    public boolean isNSFW();

    @Nonnull
    public static CommandData fromCommand(@Nonnull Command command) {
        Checks.notNull(command, "Command");
        if (command.getType() != Command.Type.SLASH) {
            CommandDataImpl data = new CommandDataImpl(command.getType(), command.getName());
            return ((CommandDataImpl)data.setDefaultPermissions(command.getDefaultPermissions()).setGuildOnly(command.isGuildOnly()).setNSFW(command.isNSFW()).setNameLocalizations((Map)command.getNameLocalizations().toMap())).setDescriptionLocalizations((Map)command.getDescriptionLocalizations().toMap());
        }
        return SlashCommandData.fromCommand(command);
    }

    @Nonnull
    public static CommandData fromData(@Nonnull DataObject object) {
        Checks.notNull(object, "DataObject");
        String name = object.getString("name");
        Command.Type commandType = Command.Type.fromId(object.getInt("type", 1));
        if (commandType != Command.Type.SLASH) {
            CommandDataImpl data = new CommandDataImpl(commandType, name);
            if (!object.isNull("default_member_permissions")) {
                long defaultPermissions = object.getLong("default_member_permissions");
                data.setDefaultPermissions(defaultPermissions == 0L ? DefaultMemberPermissions.DISABLED : DefaultMemberPermissions.enabledFor(defaultPermissions));
            }
            data.setGuildOnly(!object.getBoolean("dm_permission", true));
            data.setNSFW(object.getBoolean("nsfw"));
            data.setNameLocalizations((Map)LocalizationUtils.mapFromProperty(object, "name_localizations"));
            data.setDescriptionLocalizations((Map)LocalizationUtils.mapFromProperty(object, "description_localizations"));
            return data;
        }
        return SlashCommandData.fromData(object);
    }
}

