/*
 * Decompiled with CFR 0.152.
 */
package ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.entities.Icon;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.api.utils.FileProxy;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.internal.utils.Checks;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.internal.utils.FutureUtil;
import ooo.foooooooooooo.velocitydiscord.lib.net.dv8tion.jda.internal.utils.IOUtil;

public class AttachmentProxy
extends FileProxy {
    public AttachmentProxy(@Nonnull String url) {
        super(url);
    }

    @Nonnull
    public String getUrl(int width, int height) {
        Checks.positive(width, "Image width");
        Checks.positive(height, "Image height");
        return IOUtil.addQuery(this.getUrl(), "width", width, "height", height);
    }

    @Nonnull
    public CompletableFuture<InputStream> download(int width, int height) {
        return this.download(this.getUrl(width, height));
    }

    @Nonnull
    public CompletableFuture<Path> downloadToPath(int width, int height) {
        return this.downloadToPath(this.getUrl(width, height));
    }

    @Nonnull
    public CompletableFuture<File> downloadToFile(@Nonnull File file, int width, int height) {
        Checks.notNull(file, "File");
        CompletableFuture<Path> downloadToPathFuture = this.downloadToPath(this.getUrl(width, height), file.toPath());
        return FutureUtil.thenApplyCancellable(downloadToPathFuture, Path::toFile);
    }

    @Nonnull
    public CompletableFuture<Path> downloadToPath(@Nonnull Path path, int width, int height) {
        Checks.notNull(path, "Path");
        return this.downloadToPath(this.getUrl(width, height), path);
    }

    @Nonnull
    private CompletableFuture<Icon> downloadAsIcon(String url) {
        CompletableFuture<InputStream> downloadFuture = this.download(url);
        return FutureUtil.thenApplyCancellable(downloadFuture, stream -> {
            Icon icon;
            block8: {
                InputStream ignored = stream;
                try {
                    icon = Icon.from(stream);
                    if (ignored == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                ignored.close();
            }
            return icon;
        });
    }

    @Nonnull
    public CompletableFuture<Icon> downloadAsIcon() {
        return this.downloadAsIcon(this.getUrl());
    }

    @Nonnull
    public CompletableFuture<Icon> downloadAsIcon(int width, int height) {
        return this.downloadAsIcon(this.getUrl(width, height));
    }
}

