package archives.tater.tooltrims;

import archives.tater.tooltrims.item.ToolTrimsItems;
import archives.tater.tooltrims.loot.ToolTrimsLoot;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolTrims implements ModInitializer {
	public static final String MOD_ID = "tooltrims";

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	public static class_2960 id(String path) {
		return class_2960.method_60655(MOD_ID, path);
	}

	@Override
	public void onInitialize() {
		// This code runs as soon as Minecraft is in a mod-load-ready state.
		// However, some things (like resources) may still be uninitialized.
		// Proceed with mild caution.
		ToolTrimsPatterns.register();
		ToolTrimsItems.register();
		ToolTrimsTags.register();
		ToolTrimsLoot.register();
		ToolTrimsGamerules.register();
		ToolTrimsCommands.register();
		ToolTrimsDPCompat.register();
		ToolTrimsDataAttachment.register();

		if (ToolTrimsModCompat.isEnchancementLoaded)
            //noinspection OptionalGetWithoutIsPresent
            ResourceManagerHelper.registerBuiltinResourcePack(
					ToolTrims.id("enchancement"),
					FabricLoader.getInstance().getModContainer(ToolTrims.MOD_ID).get(),
					class_2561.method_43470("Enchancement x Tool Trims"),
					ResourcePackActivationType.ALWAYS_ENABLED
			);
		//noinspection OptionalGetWithoutIsPresent
		ResourceManagerHelper.registerBuiltinResourcePack(
				ToolTrims.id("tooltrims"),
				FabricLoader.getInstance().getModContainer(ToolTrims.MOD_ID).get(),
				class_2561.method_43470("Tool Trims"),
				ResourcePackActivationType.ALWAYS_ENABLED
		);
	}
}
