package archives.tater.tooltrims;

import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2240;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import org.jetbrains.annotations.Nullable;

import static net.minecraft.class_2170.method_9247;

public class ToolTrimsCommands {

    private static final SimpleCommandExceptionType ERROR_NOPLAYER = new SimpleCommandExceptionType(class_2561.method_43471("commands.tooltrims.error.noplayer"));
    private static final SimpleCommandExceptionType ERROR_MISSING_DATAPACK = new SimpleCommandExceptionType(class_2561.method_43471("commands.tooltrims.error.demigrate.missing_datapack"));
    private static final DynamicCommandExceptionType MIGRATE_FAIL = new DynamicCommandExceptionType(itemText -> class_2561.method_43469("commands.tooltrims.migrate.error.fail", itemText));
    private static final DynamicCommandExceptionType DEMIGRATE_FAIL = new DynamicCommandExceptionType(itemText -> class_2561.method_43469("commands.tooltrims.demigrate.error.fail", itemText));

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) ->
                dispatcher.register(method_9247("tooltrims")
                    .then(method_9247("migrate")
                            .executes(ctx -> {
                                migrate(registryAccess, ctx, ctx.getSource().method_44023(), class_1304.field_6173.method_32320(class_1309.field_30071), false);
                                return 1;
                            })
                            .then(class_2170.method_9244("slot", class_2240.method_9473()).executes(ctx -> {
                                migrate(registryAccess, ctx, ctx.getSource().method_44023(), class_2240.method_9469(ctx, "slot"), false);
                                return 1;
                            })
                            .then(class_2170.method_9244("target", class_2186.method_9305()).executes(ctx -> {
                                migrate(registryAccess, ctx, class_2186.method_9315(ctx, "target"), class_2240.method_9469(ctx, "slot"), false);
                                return 1;
                            }))))
                    .then(method_9247("demigrate")
                            .executes(ctx -> {
                                migrate(registryAccess, ctx, ctx.getSource().method_44023(), class_1304.field_6173.method_32320(class_1309.field_30071), true);
                                return 1;
                            })
                            .then(class_2170.method_9244("slot", class_2240.method_9473()).executes(ctx -> {
                                migrate(registryAccess, ctx, ctx.getSource().method_44023(), class_2240.method_9469(ctx, "slot"), true);
                                return 1;
                            })
                            .then(class_2170.method_9244("target", class_2186.method_9305()).executes(ctx -> {
                                migrate(registryAccess, ctx, class_2186.method_9315(ctx, "target"), class_2240.method_9469(ctx, "slot"), true);
                                return 1;
                            }))))
        ));
    }

    public static void migrate(class_7157 registries, CommandContext<class_2168> ctx, @Nullable class_3222 player, int slot, boolean reverse) throws CommandSyntaxException {
        if (!ToolTrimsDPCompat.isDatapackRunning(ctx.getSource().method_9211())) throw ERROR_MISSING_DATAPACK.create();
        if (player == null) throw ERROR_NOPLAYER.create();
        var stackReference = player.method_32318(slot);
        var currentStack = stackReference.method_32327();
        var newStack = reverse ? ToolTrimsDPCompat.demigrateItem(player.method_51469(), registries, currentStack) : ToolTrimsDPCompat.migrateItem(player.method_51469(), currentStack);
        if (newStack == null)
            throw (reverse ? DEMIGRATE_FAIL : MIGRATE_FAIL).create(currentStack.method_7954());
        stackReference.method_32332(newStack);
        ctx.getSource().method_9226(() -> class_2561.method_43469(reverse ? "commands.tooltrims.demigrate.success" : "commands.tooltrims.migrate.success", newStack.method_7954()), true);
    }
}
