package archives.tater.tooltrims.loot;

import archives.tater.tooltrims.ToolTrims;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;

public class ToolTrimsLoot {
    private static class_5321<class_52> idInject(class_5321<class_52> lootTable) {
        return class_5321.method_29179(lootTable.method_58273(), ToolTrims.id("inject/" + lootTable.method_29177().method_12836() + "/" + lootTable.method_29177().method_12832()));
    }

    public static final class_5321<class_52> TRAIL_RUINS_INJECT = idInject(class_39.field_44649);
    public static final class_5321<class_52> PILLAGER_OUTPOST_INJECT = idInject(class_39.field_16593);
    public static final class_5321<class_52> ANCIENCT_CITY_INJECT = idInject(class_39.field_38438);
    public static final class_5321<class_52> IGLOO_INJECT = idInject(class_39.field_662);
    public static final class_5321<class_52> MINESHAFT_INJECT = idInject(class_39.field_472);
    public static final class_5321<class_52> MANSION_INJECT = idInject(class_39.field_484);

    sealed interface LootModifyEntry {
        class_5321<class_52> targetTable();
    }

    record AddPoolEntry(
        class_5321<class_52> targetTable,
        class_5321<class_52> injectTableId
    ) implements LootModifyEntry {}

    sealed interface PoolModifyEntry extends LootModifyEntry {
        int poolIndex();
    }

    record ChangeWeightEntry(
            class_5321<class_52> targetTable,
            int poolIndex,
            int entryIndex,
            int weightChange
    ) implements PoolModifyEntry {}

    record AddEntry(
            class_5321<class_52> targetTable,
            int poolIndex,
            class_5321<class_52> injectTable,
            int weight
    ) implements PoolModifyEntry {}

    record DeleteEntry( // Note: Operation is not atomic, so deleting items 1 and 2 will actually delete 1 and 3
            class_5321<class_52> targetTable,
            int poolIndex,
            int entryIndex
    ) implements PoolModifyEntry {}

    private static final LootModifyEntry[] MODIFY_ENTRIES = {
            new AddEntry(class_39.field_44649, 0, TRAIL_RUINS_INJECT, 1),

            new ChangeWeightEntry(class_39.field_16593, 5, 1, 1),
            new AddEntry(class_39.field_16593, 5, PILLAGER_OUTPOST_INJECT, 1),

            new ChangeWeightEntry(class_39.field_38438, 1, 0, -4),
            new AddEntry(class_39.field_38438, 1, ANCIENCT_CITY_INJECT, 4),

            new AddPoolEntry(class_39.field_662, IGLOO_INJECT),

            new DeleteEntry(class_39.field_472, 0, 5),
            new AddEntry(class_39.field_472, 0, MINESHAFT_INJECT, 5),

            new DeleteEntry(class_39.field_484, 3, 0),
            new AddEntry(class_39.field_484, 3, MANSION_INJECT, 1)
    };

    public static void register() {

        LootTableEvents.MODIFY.register((key, builder, source, wrapperLookup) -> {
            if (!source.isBuiltin()) return;

            var needsModification = false;

            for (var entry : MODIFY_ENTRIES) {
                if (!(entry.targetTable().getValue().equals(key.getValue()))) continue;

                if (entry instanceof AddPoolEntry addPoolEntry)
                    builder.pool(LootPool.builder()
                            .with(LootTableEntry.builder(addPoolEntry.injectTableId)));
                else if (entry instanceof PoolModifyEntry)
                    needsModification = true;
            }

            if (!needsModification) return;

            ((ReplaceablePools) builder).tooltrims$modifyPoolEntries((entries, index) -> {
                for (var entry : MODIFY_ENTRIES) {
                    if (!(entry.targetTable().getValue().equals(key.getValue()))) continue;
                    if (!(entry instanceof PoolModifyEntry poolModifyEntry) || poolModifyEntry.poolIndex() != index) continue;

                    switch (entry) {
                        case AddEntry addEntry -> {
                            var lootEntry = LootTableEntry.builder(addEntry.injectTable);
                            if (addEntry.weight != 1)
                                lootEntry.weight(addEntry.weight);
                            entries.add(lootEntry.build());
                        }
                        case DeleteEntry deleteEntry -> entries.remove(deleteEntry.entryIndex);
                        case ChangeWeightEntry changeWeightEntry -> {
                            if (changeWeightEntry.entryIndex < entries.size() && entries.get(changeWeightEntry.entryIndex) instanceof CopyWithWeight<?> copyableEntry)
                                entries.set(changeWeightEntry.entryIndex, (LootPoolEntry) copyableEntry.tooltrims$copy(changeWeightEntry.weightChange));
                        }
                        default -> {
                        }
                    }
                }
            });
        });
    }
}
