package archives.tater.tooltrims.mixin.client;

import archives.tater.tooltrims.ToolTrimsDataAttachment;
import archives.tater.tooltrims.TridentTextures;
import archives.tater.tooltrims.duck.TrimmedState;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;
import net.minecraft.class_10073;
import net.minecraft.class_1685;
import net.minecraft.class_2960;
import net.minecraft.class_955;

@SuppressWarnings("UnstableApiUsage")
@Mixin(class_955.class)
public class TridentEntityRendererMixin {
    @Inject(
            method = "updateRenderState(Lnet/minecraft/entity/projectile/TridentEntity;Lnet/minecraft/client/render/entity/state/TridentEntityRenderState;F)V",
            at = @At("TAIL")
    )
    private void addTrimState(class_1685 tridentEntity, class_10073 tridentEntityRenderState, float f, CallbackInfo ci) {
        ((TrimmedState) tridentEntityRenderState).tooltrims$setTrim(tridentEntity.getAttached(ToolTrimsDataAttachment.TRIDENT_TRIM));
    }

    @ModifyArg(
            method = "render(Lnet/minecraft/client/render/entity/state/TridentEntityRenderState;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/entity/model/TridentEntityModel;getLayer(Lnet/minecraft/util/Identifier;)Lnet/minecraft/client/render/RenderLayer;"),
            index = 0
    )
    private class_2960 applyTrimTexture(class_2960 original, @Local(argsOnly = true) class_10073 tridentEntityRenderState) {
        return Objects.requireNonNullElse(TridentTextures.getTextureId(((TrimmedState) tridentEntityRenderState).tooltrims$getTrim()), original);
    }
}
